<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatisticsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of Statistic Elements.
 * @subpackage Structs
 */
class StatisticsType extends AbstractStructBase
{
    /**
     * The Statistic
     * Meta information extracted from the WSDL
     * - documentation: Used to define the report fiscal date, report code, and the hotel(s) for which data is being reported.
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $Statistic;
    /**
     * Constructor method for StatisticsType
     * @uses StatisticsType::setStatistic()
     * @param mixed[] $statistic
     */
    public function __construct(array $statistic = array())
    {
        $this
            ->setStatistic($statistic);
    }
    /**
     * Get Statistic value
     * @return mixed[]|null
     */
    public function getStatistic()
    {
        return $this->Statistic;
    }
    /**
     * This method is responsible for validating the values passed to the setStatistic method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatistic method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatisticForArrayConstraintsFromSetStatistic(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $statisticsTypeStatisticItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($statisticsTypeStatisticItem) ? get_class($statisticsTypeStatisticItem) : sprintf('%s(%s)', gettype($statisticsTypeStatisticItem), var_export($statisticsTypeStatisticItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Statistic property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Statistic value
     * @throws \InvalidArgumentException
     * @param mixed[] $statistic
     * @return \StructType\StatisticsType
     */
    public function setStatistic(array $statistic = array())
    {
        // validation for constraint: array
        if ('' !== ($statisticArrayErrorMessage = self::validateStatisticForArrayConstraintsFromSetStatistic($statistic))) {
            throw new \InvalidArgumentException($statisticArrayErrorMessage, __LINE__);
        }
        $this->Statistic = $statistic;
        return $this;
    }
    /**
     * Add item to Statistic value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\StatisticsType
     */
    public function addToStatistic($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Statistic property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Statistic[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StatisticsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
