<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatisticApplicationSetType StructType
 * Meta information extracted from the WSDL
 * - documentation: Includes the statistic data reported and the codes for which it has been aggregated, if applicable. The applicable date range for the data is defined in its attributes.
 * @subpackage Structs
 */
class StatisticApplicationSetType extends AbstractStructBase
{
    /**
     * The StatisticCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\StatisticCodes
     */
    public $StatisticCodes;
    /**
     * The RevenueCategorySummaries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RevenueCategorySummaries
     */
    public $RevenueCategorySummaries;
    /**
     * The CountCategorySummaries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CountCategorySummaries
     */
    public $CountCategorySummaries;
    /**
     * The ReportSummaries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ReportSummaries
     */
    public $ReportSummaries;
    /**
     * Constructor method for StatisticApplicationSetType
     * @uses StatisticApplicationSetType::setStatisticCodes()
     * @uses StatisticApplicationSetType::setRevenueCategorySummaries()
     * @uses StatisticApplicationSetType::setCountCategorySummaries()
     * @uses StatisticApplicationSetType::setReportSummaries()
     * @param \StructType\StatisticCodes $statisticCodes
     * @param \StructType\RevenueCategorySummaries $revenueCategorySummaries
     * @param \StructType\CountCategorySummaries $countCategorySummaries
     * @param \StructType\ReportSummaries $reportSummaries
     */
    public function __construct(\StructType\StatisticCodes $statisticCodes = null, \StructType\RevenueCategorySummaries $revenueCategorySummaries = null, \StructType\CountCategorySummaries $countCategorySummaries = null, \StructType\ReportSummaries $reportSummaries = null)
    {
        $this
            ->setStatisticCodes($statisticCodes)
            ->setRevenueCategorySummaries($revenueCategorySummaries)
            ->setCountCategorySummaries($countCategorySummaries)
            ->setReportSummaries($reportSummaries);
    }
    /**
     * Get StatisticCodes value
     * @return \StructType\StatisticCodes|null
     */
    public function getStatisticCodes()
    {
        return $this->StatisticCodes;
    }
    /**
     * Set StatisticCodes value
     * @param \StructType\StatisticCodes $statisticCodes
     * @return \StructType\StatisticApplicationSetType
     */
    public function setStatisticCodes(\StructType\StatisticCodes $statisticCodes = null)
    {
        $this->StatisticCodes = $statisticCodes;
        return $this;
    }
    /**
     * Get RevenueCategorySummaries value
     * @return \StructType\RevenueCategorySummaries|null
     */
    public function getRevenueCategorySummaries()
    {
        return $this->RevenueCategorySummaries;
    }
    /**
     * Set RevenueCategorySummaries value
     * @param \StructType\RevenueCategorySummaries $revenueCategorySummaries
     * @return \StructType\StatisticApplicationSetType
     */
    public function setRevenueCategorySummaries(\StructType\RevenueCategorySummaries $revenueCategorySummaries = null)
    {
        $this->RevenueCategorySummaries = $revenueCategorySummaries;
        return $this;
    }
    /**
     * Get CountCategorySummaries value
     * @return \StructType\CountCategorySummaries|null
     */
    public function getCountCategorySummaries()
    {
        return $this->CountCategorySummaries;
    }
    /**
     * Set CountCategorySummaries value
     * @param \StructType\CountCategorySummaries $countCategorySummaries
     * @return \StructType\StatisticApplicationSetType
     */
    public function setCountCategorySummaries(\StructType\CountCategorySummaries $countCategorySummaries = null)
    {
        $this->CountCategorySummaries = $countCategorySummaries;
        return $this;
    }
    /**
     * Get ReportSummaries value
     * @return \StructType\ReportSummaries|null
     */
    public function getReportSummaries()
    {
        return $this->ReportSummaries;
    }
    /**
     * Set ReportSummaries value
     * @param \StructType\ReportSummaries $reportSummaries
     * @return \StructType\StatisticApplicationSetType
     */
    public function setReportSummaries(\StructType\ReportSummaries $reportSummaries = null)
    {
        $this->ReportSummaries = $reportSummaries;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StatisticApplicationSetType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
