<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines information used to fully describe a train station.
 * @subpackage Structs
 */
class StationType extends LocationType
{
    /**
     * The IsStaffedInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the train station is staffed.
     * - use: optional
     * @var bool
     */
    public $IsStaffedInd;
    /**
     * The TicketPrinterInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the train station has ticket printing facilities.
     * - use: optional
     * @var bool
     */
    public $TicketPrinterInd;
    /**
     * The SST_MachineInd
     * Meta information extracted from the WSDL
     * - documentation: When true, self service technology (e.g. ticket machines that accept credit cards and/or cash) are available.
     * - use: optional
     * @var bool
     */
    public $SST_MachineInd;
    /**
     * The TimeZoneOffset
     * Meta information extracted from the WSDL
     * - documentation: The time zone for the train station schedules and availability that's derived by an offset from the UTC time.
     * - use: optional
     * @var string
     */
    public $TimeZoneOffset;
    /**
     * Constructor method for StationType
     * @uses StationType::setIsStaffedInd()
     * @uses StationType::setTicketPrinterInd()
     * @uses StationType::setSST_MachineInd()
     * @uses StationType::setTimeZoneOffset()
     * @param bool $isStaffedInd
     * @param bool $ticketPrinterInd
     * @param bool $sST_MachineInd
     * @param string $timeZoneOffset
     */
    public function __construct($isStaffedInd = null, $ticketPrinterInd = null, $sST_MachineInd = null, $timeZoneOffset = null)
    {
        $this
            ->setIsStaffedInd($isStaffedInd)
            ->setTicketPrinterInd($ticketPrinterInd)
            ->setSST_MachineInd($sST_MachineInd)
            ->setTimeZoneOffset($timeZoneOffset);
    }
    /**
     * Get IsStaffedInd value
     * @return bool|null
     */
    public function getIsStaffedInd()
    {
        return $this->IsStaffedInd;
    }
    /**
     * Set IsStaffedInd value
     * @param bool $isStaffedInd
     * @return \StructType\StationType
     */
    public function setIsStaffedInd($isStaffedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($isStaffedInd) && !is_bool($isStaffedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isStaffedInd, true), gettype($isStaffedInd)), __LINE__);
        }
        $this->IsStaffedInd = $isStaffedInd;
        return $this;
    }
    /**
     * Get TicketPrinterInd value
     * @return bool|null
     */
    public function getTicketPrinterInd()
    {
        return $this->TicketPrinterInd;
    }
    /**
     * Set TicketPrinterInd value
     * @param bool $ticketPrinterInd
     * @return \StructType\StationType
     */
    public function setTicketPrinterInd($ticketPrinterInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($ticketPrinterInd) && !is_bool($ticketPrinterInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ticketPrinterInd, true), gettype($ticketPrinterInd)), __LINE__);
        }
        $this->TicketPrinterInd = $ticketPrinterInd;
        return $this;
    }
    /**
     * Get SST_MachineInd value
     * @return bool|null
     */
    public function getSST_MachineInd()
    {
        return $this->SST_MachineInd;
    }
    /**
     * Set SST_MachineInd value
     * @param bool $sST_MachineInd
     * @return \StructType\StationType
     */
    public function setSST_MachineInd($sST_MachineInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($sST_MachineInd) && !is_bool($sST_MachineInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sST_MachineInd, true), gettype($sST_MachineInd)), __LINE__);
        }
        $this->SST_MachineInd = $sST_MachineInd;
        return $this;
    }
    /**
     * Get TimeZoneOffset value
     * @return string|null
     */
    public function getTimeZoneOffset()
    {
        return $this->TimeZoneOffset;
    }
    /**
     * Set TimeZoneOffset value
     * @param string $timeZoneOffset
     * @return \StructType\StationType
     */
    public function setTimeZoneOffset($timeZoneOffset = null)
    {
        // validation for constraint: string
        if (!is_null($timeZoneOffset) && !is_string($timeZoneOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeZoneOffset, true), gettype($timeZoneOffset)), __LINE__);
        }
        $this->TimeZoneOffset = $timeZoneOffset;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
