<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StationDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines operation and location details for a train station.
 * @subpackage Structs
 */
class StationDetailsType extends AbstractStructBase
{
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - documentation: Detailed station information.
     * @var mixed
     */
    public $Details;
    /**
     * The OperationSchedules
     * Meta information extracted from the WSDL
     * - documentation: Operation schedules for the station.
     * - minOccurs: 0
     * @var mixed
     */
    public $OperationSchedules;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Address information for the station.
     * - minOccurs: 0
     * @var mixed
     */
    public $Address;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Telephone[]
     */
    public $Telephone;
    /**
     * Constructor method for StationDetailsType
     * @uses StationDetailsType::setDetails()
     * @uses StationDetailsType::setOperationSchedules()
     * @uses StationDetailsType::setAddress()
     * @uses StationDetailsType::setTelephone()
     * @param mixed $details
     * @param mixed $operationSchedules
     * @param mixed $address
     * @param \StructType\Telephone[] $telephone
     */
    public function __construct($details = null, $operationSchedules = null, $address = null, array $telephone = array())
    {
        $this
            ->setDetails($details)
            ->setOperationSchedules($operationSchedules)
            ->setAddress($address)
            ->setTelephone($telephone);
    }
    /**
     * Get Details value
     * @return mixed|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param mixed $details
     * @return \StructType\StationDetailsType
     */
    public function setDetails($details = null)
    {
        $this->Details = $details;
        return $this;
    }
    /**
     * Get OperationSchedules value
     * @return mixed|null
     */
    public function getOperationSchedules()
    {
        return $this->OperationSchedules;
    }
    /**
     * Set OperationSchedules value
     * @param mixed $operationSchedules
     * @return \StructType\StationDetailsType
     */
    public function setOperationSchedules($operationSchedules = null)
    {
        $this->OperationSchedules = $operationSchedules;
        return $this;
    }
    /**
     * Get Address value
     * @return mixed|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param mixed $address
     * @return \StructType\StationDetailsType
     */
    public function setAddress($address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneForArrayConstraintsFromSetTelephone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $stationDetailsTypeTelephoneItem) {
            // validation for constraint: itemType
            if (!$stationDetailsTypeTelephoneItem instanceof \StructType\Telephone) {
                $invalidValues[] = is_object($stationDetailsTypeTelephoneItem) ? get_class($stationDetailsTypeTelephoneItem) : sprintf('%s(%s)', gettype($stationDetailsTypeTelephoneItem), var_export($stationDetailsTypeTelephoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone[] $telephone
     * @return \StructType\StationDetailsType
     */
    public function setTelephone(array $telephone = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneArrayErrorMessage = self::validateTelephoneForArrayConstraintsFromSetTelephone($telephone))) {
            throw new \InvalidArgumentException($telephoneArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($telephone) && count($telephone) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\Telephone $item
     * @return \StructType\StationDetailsType
     */
    public function addToTelephone(\StructType\Telephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Telephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of type \StructType\Telephone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Telephone) && count($this->Telephone) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Telephone)), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StationDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
