<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialServiceRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: SSR's for this booking request, for example meals.
 * @subpackage Structs
 */
class SpecialServiceRequestType extends AbstractStructBase
{
    /**
     * The SSRCode
     * Meta information extracted from the WSDL
     * - documentation: The four alpha position industry code identifying a particular type of special service request.
     * - use: required
     * @var string
     */
    public $SSRCode;
    /**
     * The Airline
     * Meta information extracted from the WSDL
     * - documentation: Specify airline to request availability for.
     * - minOccurs: 0
     * @var mixed
     */
    public $Airline;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: Text associated with remark.
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The ServiceQuantity
     * Meta information extracted from the WSDL
     * - documentation: Used to specify the number of special services.
     * - use: optional
     * @var int
     */
    public $ServiceQuantity;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Code providing status information for this special service request. Refer to OpenTravel Code List Status (STS).
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: A number which identifies an SSR in a system.
     * - use: optional
     * @var int
     */
    public $Number;
    /**
     * Constructor method for SpecialServiceRequestType
     * @uses SpecialServiceRequestType::setSSRCode()
     * @uses SpecialServiceRequestType::setAirline()
     * @uses SpecialServiceRequestType::setText()
     * @uses SpecialServiceRequestType::setServiceQuantity()
     * @uses SpecialServiceRequestType::setStatus()
     * @uses SpecialServiceRequestType::setNumber()
     * @param string $sSRCode
     * @param mixed $airline
     * @param string $text
     * @param int $serviceQuantity
     * @param string $status
     * @param int $number
     */
    public function __construct($sSRCode = null, $airline = null, $text = null, $serviceQuantity = null, $status = null, $number = null)
    {
        $this
            ->setSSRCode($sSRCode)
            ->setAirline($airline)
            ->setText($text)
            ->setServiceQuantity($serviceQuantity)
            ->setStatus($status)
            ->setNumber($number);
    }
    /**
     * Get SSRCode value
     * @return string
     */
    public function getSSRCode()
    {
        return $this->SSRCode;
    }
    /**
     * Set SSRCode value
     * @param string $sSRCode
     * @return \StructType\SpecialServiceRequestType
     */
    public function setSSRCode($sSRCode = null)
    {
        // validation for constraint: string
        if (!is_null($sSRCode) && !is_string($sSRCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSRCode, true), gettype($sSRCode)), __LINE__);
        }
        $this->SSRCode = $sSRCode;
        return $this;
    }
    /**
     * Get Airline value
     * @return mixed|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param mixed $airline
     * @return \StructType\SpecialServiceRequestType
     */
    public function setAirline($airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\SpecialServiceRequestType
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get ServiceQuantity value
     * @return int|null
     */
    public function getServiceQuantity()
    {
        return $this->ServiceQuantity;
    }
    /**
     * Set ServiceQuantity value
     * @param int $serviceQuantity
     * @return \StructType\SpecialServiceRequestType
     */
    public function setServiceQuantity($serviceQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($serviceQuantity) && !(is_int($serviceQuantity) || ctype_digit($serviceQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceQuantity, true), gettype($serviceQuantity)), __LINE__);
        }
        $this->ServiceQuantity = $serviceQuantity;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\SpecialServiceRequestType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\SpecialServiceRequestType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecialServiceRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
