<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialServiceRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: The birth date of the traveler to whom this SSR applies. | AWG to revisit. | Special Service Requests (SSR) for this booking.
 * @subpackage Structs
 */
class SpecialServiceRequest extends SpecialServiceRequestType
{
    /**
     * The FlightLeg
     * Meta information extracted from the WSDL
     * - documentation: Flight information associated to this special request, used when FlightRefNumberRPHList is not available or is different.
     * - minOccurs: 0
     * @var mixed
     */
    public $FlightLeg;
    /**
     * The TravelerRefNumberRPHList
     * Meta information extracted from the WSDL
     * - documentation: One or more travelers to whom this request applies.
     * - use: optional
     * @var list
     */
    public $TravelerRefNumberRPHList;
    /**
     * The FlightRefNumberRPHList
     * Meta information extracted from the WSDL
     * - documentation: One or more flights to whom this request applies.
     * - use: optional
     * @var list
     */
    public $FlightRefNumberRPHList;
    /**
     * Constructor method for SpecialServiceRequest
     * @uses SpecialServiceRequest::setFlightLeg()
     * @uses SpecialServiceRequest::setTravelerRefNumberRPHList()
     * @uses SpecialServiceRequest::setFlightRefNumberRPHList()
     * @param mixed $flightLeg
     * @param list $travelerRefNumberRPHList
     * @param list $flightRefNumberRPHList
     */
    public function __construct($flightLeg = null, list $travelerRefNumberRPHList = null, list $flightRefNumberRPHList = null)
    {
        $this
            ->setFlightLeg($flightLeg)
            ->setTravelerRefNumberRPHList($travelerRefNumberRPHList)
            ->setFlightRefNumberRPHList($flightRefNumberRPHList);
    }
    /**
     * Get FlightLeg value
     * @return mixed|null
     */
    public function getFlightLeg()
    {
        return $this->FlightLeg;
    }
    /**
     * Set FlightLeg value
     * @param mixed $flightLeg
     * @return \StructType\SpecialServiceRequest
     */
    public function setFlightLeg($flightLeg = null)
    {
        $this->FlightLeg = $flightLeg;
        return $this;
    }
    /**
     * Get TravelerRefNumberRPHList value
     * @return list|null
     */
    public function getTravelerRefNumberRPHList()
    {
        return $this->TravelerRefNumberRPHList;
    }
    /**
     * Set TravelerRefNumberRPHList value
     * @param list $travelerRefNumberRPHList
     * @return \StructType\SpecialServiceRequest
     */
    public function setTravelerRefNumberRPHList(list $travelerRefNumberRPHList = null)
    {
        $this->TravelerRefNumberRPHList = $travelerRefNumberRPHList;
        return $this;
    }
    /**
     * Get FlightRefNumberRPHList value
     * @return list|null
     */
    public function getFlightRefNumberRPHList()
    {
        return $this->FlightRefNumberRPHList;
    }
    /**
     * Set FlightRefNumberRPHList value
     * @param list $flightRefNumberRPHList
     * @return \StructType\SpecialServiceRequest
     */
    public function setFlightRefNumberRPHList(list $flightRefNumberRPHList = null)
    {
        $this->FlightRefNumberRPHList = $flightRefNumberRPHList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecialServiceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
