<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecialRemark StructType
 * Meta information extracted from the WSDL
 * - documentation: Itinerary Remarks, Invoice Remarks, etc.
 * @subpackage Structs
 */
class SpecialRemark extends SpecialRemarkType
{
    /**
     * The FlightLeg
     * Meta information extracted from the WSDL
     * - documentation: Flight information associated to this special remark, used when FlightRefNumberRPHList is not available or is different.
     * - minOccurs: 0
     * @var mixed
     */
    public $FlightLeg;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: Unique value associated with the Special Remark.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for SpecialRemark
     * @uses SpecialRemark::setFlightLeg()
     * @uses SpecialRemark::setOperation()
     * @uses SpecialRemark::setRPH()
     * @param mixed $flightLeg
     * @param string $operation
     * @param string $rPH
     */
    public function __construct($flightLeg = null, $operation = null, $rPH = null)
    {
        $this
            ->setFlightLeg($flightLeg)
            ->setOperation($operation)
            ->setRPH($rPH);
    }
    /**
     * Get FlightLeg value
     * @return mixed|null
     */
    public function getFlightLeg()
    {
        return $this->FlightLeg;
    }
    /**
     * Set FlightLeg value
     * @param mixed $flightLeg
     * @return \StructType\SpecialRemark
     */
    public function setFlightLeg($flightLeg = null)
    {
        $this->FlightLeg = $flightLeg;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\SpecialRemark
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\SpecialRemark
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpecialRemark
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
