<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShuttleInfos StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of descriptions about various aspects of the Shuttle Services.
 * @subpackage Structs
 */
class ShuttleInfos extends AbstractStructBase
{
    /**
     * The ShuttleInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\ShuttleInfo[]
     */
    public $ShuttleInfo;
    /**
     * Constructor method for ShuttleInfos
     * @uses ShuttleInfos::setShuttleInfo()
     * @param \StructType\ShuttleInfo[] $shuttleInfo
     */
    public function __construct(array $shuttleInfo = array())
    {
        $this
            ->setShuttleInfo($shuttleInfo);
    }
    /**
     * Get ShuttleInfo value
     * @return \StructType\ShuttleInfo[]|null
     */
    public function getShuttleInfo()
    {
        return $this->ShuttleInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setShuttleInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShuttleInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShuttleInfoForArrayConstraintsFromSetShuttleInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $shuttleInfosShuttleInfoItem) {
            // validation for constraint: itemType
            if (!$shuttleInfosShuttleInfoItem instanceof \StructType\ShuttleInfo) {
                $invalidValues[] = is_object($shuttleInfosShuttleInfoItem) ? get_class($shuttleInfosShuttleInfoItem) : sprintf('%s(%s)', gettype($shuttleInfosShuttleInfoItem), var_export($shuttleInfosShuttleInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ShuttleInfo property can only contain items of type \StructType\ShuttleInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ShuttleInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ShuttleInfo[] $shuttleInfo
     * @return \StructType\ShuttleInfos
     */
    public function setShuttleInfo(array $shuttleInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($shuttleInfoArrayErrorMessage = self::validateShuttleInfoForArrayConstraintsFromSetShuttleInfo($shuttleInfo))) {
            throw new \InvalidArgumentException($shuttleInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($shuttleInfo) && count($shuttleInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($shuttleInfo)), __LINE__);
        }
        $this->ShuttleInfo = $shuttleInfo;
        return $this;
    }
    /**
     * Add item to ShuttleInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\ShuttleInfo $item
     * @return \StructType\ShuttleInfos
     */
    public function addToShuttleInfo(\StructType\ShuttleInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShuttleInfo) {
            throw new \InvalidArgumentException(sprintf('The ShuttleInfo property can only contain items of type \StructType\ShuttleInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->ShuttleInfo) && count($this->ShuttleInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->ShuttleInfo)), __LINE__);
        }
        $this->ShuttleInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ShuttleInfos
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
