<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: A ServiceType class.
 * @subpackage Structs
 */
class ServiceType extends AbstractStructBase
{
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: The selling price of this Service.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Price;
    /**
     * The ServiceDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ServiceDetails
     */
    public $ServiceDetails;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The ServicePricingType
     * Meta information extracted from the WSDL
     * - documentation: An enumerated type that defines how a service is priced. Values: Per stay, Per person, Per night, Per person per night, Per use.
     * - use: optional
     * @var string
     */
    public $ServicePricingType;
    /**
     * The ReservationStatusType
     * Meta information extracted from the WSDL
     * - documentation: An enumerated type that defines the status of the reservation for this service.
     * - use: optional
     * @var string
     */
    public $ReservationStatusType;
    /**
     * The ServiceRPH
     * Meta information extracted from the WSDL
     * - documentation: A unique ID for a service that may be referenced elsewhere in the schema.
     * - use: optional
     * @var string
     */
    public $ServiceRPH;
    /**
     * The ServiceInventoryCode
     * Meta information extracted from the WSDL
     * - documentation: The representation of the specific service being reserved.
     * - use: optional
     * @var string
     */
    public $ServiceInventoryCode;
    /**
     * The RatePlanCode
     * Meta information extracted from the WSDL
     * - documentation: The representation of the rate plan under which this service was booked.
     * - use: optional
     * @var string
     */
    public $RatePlanCode;
    /**
     * The InventoryBlockCode
     * Meta information extracted from the WSDL
     * - documentation: The representation of the block code under which the inventory for this service is categorized.
     * - use: optional
     * @var string
     */
    public $InventoryBlockCode;
    /**
     * The PriceGuaranteed
     * Meta information extracted from the WSDL
     * - documentation: Whether the price for this service is guaranteed or quoted and subject to change. Values: False (Price NOT guaranteed) and True (Price is guaranteed).
     * - use: optional
     * @var bool
     */
    public $PriceGuaranteed;
    /**
     * The Inclusive
     * Meta information extracted from the WSDL
     * - documentation: Whether the price for this service is included in the room rate.Values: False (or No), and True (or Yes).
     * - use: optional
     * @var bool
     */
    public $Inclusive;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The number of tickets, rounds of golf, etc. Also serves as the number of persons when pricing class is per person or per person per night.
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * The RequestedIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, the service has been requested by the guest.
     * - use: optional
     * @var bool
     */
    public $RequestedIndicator;
    /**
     * The RequiredInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the service is required and/or mandatory.
     * - use: optional
     * @var bool
     */
    public $RequiredInd;
    /**
     * The ServiceCategoryCode
     * Meta information extracted from the WSDL
     * - documentation: The representation of the specific service category for this specific service.
     * @var string
     */
    public $ServiceCategoryCode;
    /**
     * Constructor method for ServiceType
     * @uses ServiceType::setPrice()
     * @uses ServiceType::setServiceDetails()
     * @uses ServiceType::setTPA_Extensions()
     * @uses ServiceType::setServicePricingType()
     * @uses ServiceType::setReservationStatusType()
     * @uses ServiceType::setServiceRPH()
     * @uses ServiceType::setServiceInventoryCode()
     * @uses ServiceType::setRatePlanCode()
     * @uses ServiceType::setInventoryBlockCode()
     * @uses ServiceType::setPriceGuaranteed()
     * @uses ServiceType::setInclusive()
     * @uses ServiceType::setQuantity()
     * @uses ServiceType::setRequestedIndicator()
     * @uses ServiceType::setRequiredInd()
     * @uses ServiceType::setServiceCategoryCode()
     * @param mixed[] $price
     * @param \StructType\ServiceDetails $serviceDetails
     * @param mixed $tPA_Extensions
     * @param string $servicePricingType
     * @param string $reservationStatusType
     * @param string $serviceRPH
     * @param string $serviceInventoryCode
     * @param string $ratePlanCode
     * @param string $inventoryBlockCode
     * @param bool $priceGuaranteed
     * @param bool $inclusive
     * @param int $quantity
     * @param bool $requestedIndicator
     * @param bool $requiredInd
     * @param string $serviceCategoryCode
     */
    public function __construct(array $price = array(), \StructType\ServiceDetails $serviceDetails = null, $tPA_Extensions = null, $servicePricingType = null, $reservationStatusType = null, $serviceRPH = null, $serviceInventoryCode = null, $ratePlanCode = null, $inventoryBlockCode = null, $priceGuaranteed = null, $inclusive = null, $quantity = null, $requestedIndicator = null, $requiredInd = null, $serviceCategoryCode = null)
    {
        $this
            ->setPrice($price)
            ->setServiceDetails($serviceDetails)
            ->setTPA_Extensions($tPA_Extensions)
            ->setServicePricingType($servicePricingType)
            ->setReservationStatusType($reservationStatusType)
            ->setServiceRPH($serviceRPH)
            ->setServiceInventoryCode($serviceInventoryCode)
            ->setRatePlanCode($ratePlanCode)
            ->setInventoryBlockCode($inventoryBlockCode)
            ->setPriceGuaranteed($priceGuaranteed)
            ->setInclusive($inclusive)
            ->setQuantity($quantity)
            ->setRequestedIndicator($requestedIndicator)
            ->setRequiredInd($requiredInd)
            ->setServiceCategoryCode($serviceCategoryCode);
    }
    /**
     * Get Price value
     * @return mixed[]|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * This method is responsible for validating the values passed to the setPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceForArrayConstraintsFromSetPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceTypePriceItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($serviceTypePriceItem) ? get_class($serviceTypePriceItem) : sprintf('%s(%s)', gettype($serviceTypePriceItem), var_export($serviceTypePriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Price property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Price value
     * @throws \InvalidArgumentException
     * @param mixed[] $price
     * @return \StructType\ServiceType
     */
    public function setPrice(array $price = array())
    {
        // validation for constraint: array
        if ('' !== ($priceArrayErrorMessage = self::validatePriceForArrayConstraintsFromSetPrice($price))) {
            throw new \InvalidArgumentException($priceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($price) && count($price) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($price)), __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Add item to Price value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\ServiceType
     */
    public function addToPrice($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Price property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Price) && count($this->Price) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Price)), __LINE__);
        }
        $this->Price[] = $item;
        return $this;
    }
    /**
     * Get ServiceDetails value
     * @return \StructType\ServiceDetails|null
     */
    public function getServiceDetails()
    {
        return $this->ServiceDetails;
    }
    /**
     * Set ServiceDetails value
     * @param \StructType\ServiceDetails $serviceDetails
     * @return \StructType\ServiceType
     */
    public function setServiceDetails(\StructType\ServiceDetails $serviceDetails = null)
    {
        $this->ServiceDetails = $serviceDetails;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\ServiceType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ServicePricingType value
     * @return string|null
     */
    public function getServicePricingType()
    {
        return $this->ServicePricingType;
    }
    /**
     * Set ServicePricingType value
     * @uses \EnumType\PricingType::valueIsValid()
     * @uses \EnumType\PricingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $servicePricingType
     * @return \StructType\ServiceType
     */
    public function setServicePricingType($servicePricingType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PricingType::valueIsValid($servicePricingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PricingType', is_array($servicePricingType) ? implode(', ', $servicePricingType) : var_export($servicePricingType, true), implode(', ', \EnumType\PricingType::getValidValues())), __LINE__);
        }
        $this->ServicePricingType = $servicePricingType;
        return $this;
    }
    /**
     * Get ReservationStatusType value
     * @return string|null
     */
    public function getReservationStatusType()
    {
        return $this->ReservationStatusType;
    }
    /**
     * Set ReservationStatusType value
     * @uses \EnumType\PMS_ResStatusType::valueIsValid()
     * @uses \EnumType\PMS_ResStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservationStatusType
     * @return \StructType\ServiceType
     */
    public function setReservationStatusType($reservationStatusType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PMS_ResStatusType::valueIsValid($reservationStatusType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PMS_ResStatusType', is_array($reservationStatusType) ? implode(', ', $reservationStatusType) : var_export($reservationStatusType, true), implode(', ', \EnumType\PMS_ResStatusType::getValidValues())), __LINE__);
        }
        $this->ReservationStatusType = $reservationStatusType;
        return $this;
    }
    /**
     * Get ServiceRPH value
     * @return string|null
     */
    public function getServiceRPH()
    {
        return $this->ServiceRPH;
    }
    /**
     * Set ServiceRPH value
     * @param string $serviceRPH
     * @return \StructType\ServiceType
     */
    public function setServiceRPH($serviceRPH = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRPH) && !is_string($serviceRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRPH, true), gettype($serviceRPH)), __LINE__);
        }
        $this->ServiceRPH = $serviceRPH;
        return $this;
    }
    /**
     * Get ServiceInventoryCode value
     * @return string|null
     */
    public function getServiceInventoryCode()
    {
        return $this->ServiceInventoryCode;
    }
    /**
     * Set ServiceInventoryCode value
     * @param string $serviceInventoryCode
     * @return \StructType\ServiceType
     */
    public function setServiceInventoryCode($serviceInventoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceInventoryCode) && !is_string($serviceInventoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceInventoryCode, true), gettype($serviceInventoryCode)), __LINE__);
        }
        $this->ServiceInventoryCode = $serviceInventoryCode;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\ServiceType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get InventoryBlockCode value
     * @return string|null
     */
    public function getInventoryBlockCode()
    {
        return $this->InventoryBlockCode;
    }
    /**
     * Set InventoryBlockCode value
     * @param string $inventoryBlockCode
     * @return \StructType\ServiceType
     */
    public function setInventoryBlockCode($inventoryBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryBlockCode) && !is_string($inventoryBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryBlockCode, true), gettype($inventoryBlockCode)), __LINE__);
        }
        $this->InventoryBlockCode = $inventoryBlockCode;
        return $this;
    }
    /**
     * Get PriceGuaranteed value
     * @return bool|null
     */
    public function getPriceGuaranteed()
    {
        return $this->PriceGuaranteed;
    }
    /**
     * Set PriceGuaranteed value
     * @param bool $priceGuaranteed
     * @return \StructType\ServiceType
     */
    public function setPriceGuaranteed($priceGuaranteed = null)
    {
        // validation for constraint: boolean
        if (!is_null($priceGuaranteed) && !is_bool($priceGuaranteed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($priceGuaranteed, true), gettype($priceGuaranteed)), __LINE__);
        }
        $this->PriceGuaranteed = $priceGuaranteed;
        return $this;
    }
    /**
     * Get Inclusive value
     * @return bool|null
     */
    public function getInclusive()
    {
        return $this->Inclusive;
    }
    /**
     * Set Inclusive value
     * @param bool $inclusive
     * @return \StructType\ServiceType
     */
    public function setInclusive($inclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inclusive) && !is_bool($inclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inclusive, true), gettype($inclusive)), __LINE__);
        }
        $this->Inclusive = $inclusive;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\ServiceType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get RequestedIndicator value
     * @return bool|null
     */
    public function getRequestedIndicator()
    {
        return $this->RequestedIndicator;
    }
    /**
     * Set RequestedIndicator value
     * @param bool $requestedIndicator
     * @return \StructType\ServiceType
     */
    public function setRequestedIndicator($requestedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($requestedIndicator) && !is_bool($requestedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requestedIndicator, true), gettype($requestedIndicator)), __LINE__);
        }
        $this->RequestedIndicator = $requestedIndicator;
        return $this;
    }
    /**
     * Get RequiredInd value
     * @return bool|null
     */
    public function getRequiredInd()
    {
        return $this->RequiredInd;
    }
    /**
     * Set RequiredInd value
     * @param bool $requiredInd
     * @return \StructType\ServiceType
     */
    public function setRequiredInd($requiredInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiredInd) && !is_bool($requiredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requiredInd, true), gettype($requiredInd)), __LINE__);
        }
        $this->RequiredInd = $requiredInd;
        return $this;
    }
    /**
     * Get ServiceCategoryCode value
     * @return string|null
     */
    public function getServiceCategoryCode()
    {
        return $this->ServiceCategoryCode;
    }
    /**
     * Set ServiceCategoryCode value
     * @param string $serviceCategoryCode
     * @return \StructType\ServiceType
     */
    public function setServiceCategoryCode($serviceCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCategoryCode) && !is_string($serviceCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceCategoryCode, true), gettype($serviceCategoryCode)), __LINE__);
        }
        $this->ServiceCategoryCode = $serviceCategoryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
