<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceRPHsType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of unsigned integers that reference the RPH (Reference Place holder) attribute in the Service object. The ServiceRPH attribute in the Service object is an indexing attribute that identifies the services attached to a
 * specific guest or to the reservation.
 * @subpackage Structs
 */
class ServiceRPHsType extends AbstractStructBase
{
    /**
     * The ServiceRPH
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ServiceRPH[]
     */
    public $ServiceRPH;
    /**
     * Constructor method for ServiceRPHsType
     * @uses ServiceRPHsType::setServiceRPH()
     * @param \StructType\ServiceRPH[] $serviceRPH
     */
    public function __construct(array $serviceRPH = array())
    {
        $this
            ->setServiceRPH($serviceRPH);
    }
    /**
     * Get ServiceRPH value
     * @return \StructType\ServiceRPH[]|null
     */
    public function getServiceRPH()
    {
        return $this->ServiceRPH;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceRPH method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceRPH method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceRPHForArrayConstraintsFromSetServiceRPH(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceRPHsTypeServiceRPHItem) {
            // validation for constraint: itemType
            if (!$serviceRPHsTypeServiceRPHItem instanceof \StructType\ServiceRPH) {
                $invalidValues[] = is_object($serviceRPHsTypeServiceRPHItem) ? get_class($serviceRPHsTypeServiceRPHItem) : sprintf('%s(%s)', gettype($serviceRPHsTypeServiceRPHItem), var_export($serviceRPHsTypeServiceRPHItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceRPH property can only contain items of type \StructType\ServiceRPH, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceRPH value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceRPH[] $serviceRPH
     * @return \StructType\ServiceRPHsType
     */
    public function setServiceRPH(array $serviceRPH = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceRPHArrayErrorMessage = self::validateServiceRPHForArrayConstraintsFromSetServiceRPH($serviceRPH))) {
            throw new \InvalidArgumentException($serviceRPHArrayErrorMessage, __LINE__);
        }
        $this->ServiceRPH = $serviceRPH;
        return $this;
    }
    /**
     * Add item to ServiceRPH value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceRPH $item
     * @return \StructType\ServiceRPHsType
     */
    public function addToServiceRPH(\StructType\ServiceRPH $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceRPH) {
            throw new \InvalidArgumentException(sprintf('The ServiceRPH property can only contain items of type \StructType\ServiceRPH, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceRPH[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceRPHsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
