<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SellableProduct StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the sellable date range for this product. | The individual sellable product. A sellable product may be a guest room, a meeting room or an inventory block. Attributes of SellableProduct are the inventory codes, information on
 * the use, application and sequencing of the inventory information.
 * @subpackage Structs
 */
class SellableProduct extends AbstractStructBase
{
    /**
     * The DestinationSystemCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DestinationSystemCodes
     */
    public $DestinationSystemCodes;
    /**
     * The GuestRoom
     * Meta information extracted from the WSDL
     * - documentation: Guest room information if this sellable product is a guest room.
     * - choice: GuestRoom | MeetingRooms | InventoryBlock
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var mixed
     */
    public $GuestRoom;
    /**
     * The MeetingRooms
     * Meta information extracted from the WSDL
     * - documentation: Meeting room information if this sellable product is a meeting room.
     * - choice: GuestRoom | MeetingRooms | InventoryBlock
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var mixed
     */
    public $MeetingRooms;
    /**
     * The InventoryBlock
     * Meta information extracted from the WSDL
     * - choice: GuestRoom | MeetingRooms | InventoryBlock
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\InventoryBlock
     */
    public $InventoryBlock;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Description of the sellable product.
     * - minOccurs: 0
     * @var mixed
     */
    public $Description;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: The SellableProduct class defines the inventoriable item for this rate plan.
     * - minOccurs: 0
     * @var mixed
     */
    public $UniqueID;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: This is a reference placeholder, used as an index for this sellable product.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The InvNotifType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $InvNotifType;
    /**
     * The InvStatusType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $InvStatusType;
    /**
     * The InvGroupingCode
     * Meta information extracted from the WSDL
     * - documentation: The identification of the inventory grouping. Whether to use the sending/querying or the receiving/responding system's identification depends on which system is doing the translating.
     * - use: optional
     * @var string
     */
    public $InvGroupingCode;
    /**
     * The OrderSequence
     * Meta information extracted from the WSDL
     * - documentation: The order which the items should be acknowledged by the receiving entity.
     * - use: optional
     * @var int
     */
    public $OrderSequence;
    /**
     * Constructor method for SellableProduct
     * @uses SellableProduct::setDestinationSystemCodes()
     * @uses SellableProduct::setGuestRoom()
     * @uses SellableProduct::setMeetingRooms()
     * @uses SellableProduct::setInventoryBlock()
     * @uses SellableProduct::setDescription()
     * @uses SellableProduct::setUniqueID()
     * @uses SellableProduct::setRPH()
     * @uses SellableProduct::setInvNotifType()
     * @uses SellableProduct::setInvStatusType()
     * @uses SellableProduct::setInvGroupingCode()
     * @uses SellableProduct::setOrderSequence()
     * @param \StructType\DestinationSystemCodes $destinationSystemCodes
     * @param mixed $guestRoom
     * @param mixed $meetingRooms
     * @param \StructType\InventoryBlock $inventoryBlock
     * @param mixed $description
     * @param mixed $uniqueID
     * @param string $rPH
     * @param string $invNotifType
     * @param string $invStatusType
     * @param string $invGroupingCode
     * @param int $orderSequence
     */
    public function __construct(\StructType\DestinationSystemCodes $destinationSystemCodes = null, $guestRoom = null, $meetingRooms = null, \StructType\InventoryBlock $inventoryBlock = null, $description = null, $uniqueID = null, $rPH = null, $invNotifType = null, $invStatusType = null, $invGroupingCode = null, $orderSequence = null)
    {
        $this
            ->setDestinationSystemCodes($destinationSystemCodes)
            ->setGuestRoom($guestRoom)
            ->setMeetingRooms($meetingRooms)
            ->setInventoryBlock($inventoryBlock)
            ->setDescription($description)
            ->setUniqueID($uniqueID)
            ->setRPH($rPH)
            ->setInvNotifType($invNotifType)
            ->setInvStatusType($invStatusType)
            ->setInvGroupingCode($invGroupingCode)
            ->setOrderSequence($orderSequence);
    }
    /**
     * Get DestinationSystemCodes value
     * @return \StructType\DestinationSystemCodes|null
     */
    public function getDestinationSystemCodes()
    {
        return $this->DestinationSystemCodes;
    }
    /**
     * Set DestinationSystemCodes value
     * @param \StructType\DestinationSystemCodes $destinationSystemCodes
     * @return \StructType\SellableProduct
     */
    public function setDestinationSystemCodes(\StructType\DestinationSystemCodes $destinationSystemCodes = null)
    {
        $this->DestinationSystemCodes = $destinationSystemCodes;
        return $this;
    }
    /**
     * Get GuestRoom value
     * @return mixed|null
     */
    public function getGuestRoom()
    {
        return isset($this->GuestRoom) ? $this->GuestRoom : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGuestRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuestRoom method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGuestRoomForChoiceConstraintsFromSetGuestRoom($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'MeetingRooms',
            'InventoryBlock',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GuestRoom can\'t be set as the property %s is already set. Only one property must be set among these properties: GuestRoom, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set GuestRoom value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $guestRoom
     * @return \StructType\SellableProduct
     */
    public function setGuestRoom($guestRoom = null)
    {
        // validation for constraint: choice(GuestRoom, MeetingRooms, InventoryBlock)
        if ('' !== ($guestRoomChoiceErrorMessage = self::validateGuestRoomForChoiceConstraintsFromSetGuestRoom($guestRoom))) {
            throw new \InvalidArgumentException($guestRoomChoiceErrorMessage, __LINE__);
        }
        if (is_null($guestRoom) || (is_array($guestRoom) && empty($guestRoom))) {
            unset($this->GuestRoom);
        } else {
            $this->GuestRoom = $guestRoom;
        }
        return $this;
    }
    /**
     * Get MeetingRooms value
     * @return mixed|null
     */
    public function getMeetingRooms()
    {
        return isset($this->MeetingRooms) ? $this->MeetingRooms : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMeetingRooms method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeetingRooms method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMeetingRoomsForChoiceConstraintsFromSetMeetingRooms($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'GuestRoom',
            'InventoryBlock',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property MeetingRooms can\'t be set as the property %s is already set. Only one property must be set among these properties: MeetingRooms, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set MeetingRooms value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $meetingRooms
     * @return \StructType\SellableProduct
     */
    public function setMeetingRooms($meetingRooms = null)
    {
        // validation for constraint: choice(GuestRoom, MeetingRooms, InventoryBlock)
        if ('' !== ($meetingRoomsChoiceErrorMessage = self::validateMeetingRoomsForChoiceConstraintsFromSetMeetingRooms($meetingRooms))) {
            throw new \InvalidArgumentException($meetingRoomsChoiceErrorMessage, __LINE__);
        }
        if (is_null($meetingRooms) || (is_array($meetingRooms) && empty($meetingRooms))) {
            unset($this->MeetingRooms);
        } else {
            $this->MeetingRooms = $meetingRooms;
        }
        return $this;
    }
    /**
     * Get InventoryBlock value
     * @return \StructType\InventoryBlock|null
     */
    public function getInventoryBlock()
    {
        return isset($this->InventoryBlock) ? $this->InventoryBlock : null;
    }
    /**
     * This method is responsible for validating the value passed to the setInventoryBlock method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInventoryBlock method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateInventoryBlockForChoiceConstraintsFromSetInventoryBlock($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'GuestRoom',
            'MeetingRooms',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property InventoryBlock can\'t be set as the property %s is already set. Only one property must be set among these properties: InventoryBlock, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set InventoryBlock value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryBlock $inventoryBlock
     * @return \StructType\SellableProduct
     */
    public function setInventoryBlock(\StructType\InventoryBlock $inventoryBlock = null)
    {
        // validation for constraint: choice(GuestRoom, MeetingRooms, InventoryBlock)
        if ('' !== ($inventoryBlockChoiceErrorMessage = self::validateInventoryBlockForChoiceConstraintsFromSetInventoryBlock($inventoryBlock))) {
            throw new \InvalidArgumentException($inventoryBlockChoiceErrorMessage, __LINE__);
        }
        if (is_null($inventoryBlock) || (is_array($inventoryBlock) && empty($inventoryBlock))) {
            unset($this->InventoryBlock);
        } else {
            $this->InventoryBlock = $inventoryBlock;
        }
        return $this;
    }
    /**
     * Get Description value
     * @return mixed|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param mixed $description
     * @return \StructType\SellableProduct
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return mixed|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param mixed $uniqueID
     * @return \StructType\SellableProduct
     */
    public function setUniqueID($uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\SellableProduct
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get InvNotifType value
     * @return string|null
     */
    public function getInvNotifType()
    {
        return $this->InvNotifType;
    }
    /**
     * Set InvNotifType value
     * @param string $invNotifType
     * @return \StructType\SellableProduct
     */
    public function setInvNotifType($invNotifType = null)
    {
        // validation for constraint: string
        if (!is_null($invNotifType) && !is_string($invNotifType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invNotifType, true), gettype($invNotifType)), __LINE__);
        }
        $this->InvNotifType = $invNotifType;
        return $this;
    }
    /**
     * Get InvStatusType value
     * @return string|null
     */
    public function getInvStatusType()
    {
        return $this->InvStatusType;
    }
    /**
     * Set InvStatusType value
     * @param string $invStatusType
     * @return \StructType\SellableProduct
     */
    public function setInvStatusType($invStatusType = null)
    {
        // validation for constraint: string
        if (!is_null($invStatusType) && !is_string($invStatusType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invStatusType, true), gettype($invStatusType)), __LINE__);
        }
        $this->InvStatusType = $invStatusType;
        return $this;
    }
    /**
     * Get InvGroupingCode value
     * @return string|null
     */
    public function getInvGroupingCode()
    {
        return $this->InvGroupingCode;
    }
    /**
     * Set InvGroupingCode value
     * @param string $invGroupingCode
     * @return \StructType\SellableProduct
     */
    public function setInvGroupingCode($invGroupingCode = null)
    {
        // validation for constraint: string
        if (!is_null($invGroupingCode) && !is_string($invGroupingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invGroupingCode, true), gettype($invGroupingCode)), __LINE__);
        }
        $this->InvGroupingCode = $invGroupingCode;
        return $this;
    }
    /**
     * Get OrderSequence value
     * @return int|null
     */
    public function getOrderSequence()
    {
        return $this->OrderSequence;
    }
    /**
     * Set OrderSequence value
     * @param int $orderSequence
     * @return \StructType\SellableProduct
     */
    public function setOrderSequence($orderSequence = null)
    {
        // validation for constraint: int
        if (!is_null($orderSequence) && !(is_int($orderSequence) || ctype_digit($orderSequence))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderSequence, true), gettype($orderSequence)), __LINE__);
        }
        $this->OrderSequence = $orderSequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SellableProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
