<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectionCriteria StructType
 * Meta information extracted from the WSDL
 * - documentation: The date or date range of the reservations to be selected as qualified by the DateType when present.
 * @subpackage Structs
 */
class SelectionCriteria extends AbstractStructBase
{
    /**
     * The DateType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DateType;
    /**
     * The SelectionType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SelectionType;
    /**
     * The GroupCode
     * Meta information extracted from the WSDL
     * - documentation: Code identifying a group block. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * - use: optional
     * @var string
     */
    public $GroupCode;
    /**
     * The ResStatus
     * Meta information extracted from the WSDL
     * - documentation: Specifies the status of the reservations to be delivered.
     * - use: optional
     * @var HotelResStatusType
     */
    public $ResStatus;
    /**
     * The OriginalDeliveryMethodCode
     * Meta information extracted from the WSDL
     * - documentation: The method by which the original reservation was delivered. Refer to OpenTravel Code list Distribution Type (DTB). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $OriginalDeliveryMethodCode;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * Constructor method for SelectionCriteria
     * @uses SelectionCriteria::setDateType()
     * @uses SelectionCriteria::setSelectionType()
     * @uses SelectionCriteria::setGroupCode()
     * @uses SelectionCriteria::setResStatus()
     * @uses SelectionCriteria::setOriginalDeliveryMethodCode()
     * @uses SelectionCriteria::setStart()
     * @uses SelectionCriteria::setDuration()
     * @uses SelectionCriteria::setEnd()
     * @param string $dateType
     * @param string $selectionType
     * @param string $groupCode
     * @param HotelResStatusType $resStatus
     * @param string $originalDeliveryMethodCode
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct($dateType = null, $selectionType = null, $groupCode = null, HotelResStatusType $resStatus = null, $originalDeliveryMethodCode = null, $start = null, $duration = null, $end = null)
    {
        $this
            ->setDateType($dateType)
            ->setSelectionType($selectionType)
            ->setGroupCode($groupCode)
            ->setResStatus($resStatus)
            ->setOriginalDeliveryMethodCode($originalDeliveryMethodCode)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get DateType value
     * @return string|null
     */
    public function getDateType()
    {
        return $this->DateType;
    }
    /**
     * Set DateType value
     * @param string $dateType
     * @return \StructType\SelectionCriteria
     */
    public function setDateType($dateType = null)
    {
        // validation for constraint: string
        if (!is_null($dateType) && !is_string($dateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateType, true), gettype($dateType)), __LINE__);
        }
        $this->DateType = $dateType;
        return $this;
    }
    /**
     * Get SelectionType value
     * @return string|null
     */
    public function getSelectionType()
    {
        return $this->SelectionType;
    }
    /**
     * Set SelectionType value
     * @param string $selectionType
     * @return \StructType\SelectionCriteria
     */
    public function setSelectionType($selectionType = null)
    {
        // validation for constraint: string
        if (!is_null($selectionType) && !is_string($selectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectionType, true), gettype($selectionType)), __LINE__);
        }
        $this->SelectionType = $selectionType;
        return $this;
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \StructType\SelectionCriteria
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupCode, true), gettype($groupCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($groupCode) && mb_strlen($groupCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($groupCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($groupCode) && mb_strlen($groupCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get ResStatus value
     * @return HotelResStatusType|null
     */
    public function getResStatus()
    {
        return $this->ResStatus;
    }
    /**
     * Set ResStatus value
     * @param HotelResStatusType $resStatus
     * @return \StructType\SelectionCriteria
     */
    public function setResStatus(HotelResStatusType $resStatus = null)
    {
        $this->ResStatus = $resStatus;
        return $this;
    }
    /**
     * Get OriginalDeliveryMethodCode value
     * @return string|null
     */
    public function getOriginalDeliveryMethodCode()
    {
        return $this->OriginalDeliveryMethodCode;
    }
    /**
     * Set OriginalDeliveryMethodCode value
     * @param string $originalDeliveryMethodCode
     * @return \StructType\SelectionCriteria
     */
    public function setOriginalDeliveryMethodCode($originalDeliveryMethodCode = null)
    {
        // validation for constraint: string
        if (!is_null($originalDeliveryMethodCode) && !is_string($originalDeliveryMethodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalDeliveryMethodCode, true), gettype($originalDeliveryMethodCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($originalDeliveryMethodCode) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $originalDeliveryMethodCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($originalDeliveryMethodCode, true)), __LINE__);
        }
        $this->OriginalDeliveryMethodCode = $originalDeliveryMethodCode;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\SelectionCriteria
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\SelectionCriteria
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\SelectionCriteria
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SelectionCriteria
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
