<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectedSpecialServices StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the Special Services information.
 * @subpackage Structs
 */
class SelectedSpecialServices extends AbstractStructBase
{
    /**
     * The SelectedSpecialService
     * Meta information extracted from the WSDL
     * - documentation: Specifies the Special Service information.
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var mixed[]
     */
    public $SelectedSpecialService;
    /**
     * Constructor method for SelectedSpecialServices
     * @uses SelectedSpecialServices::setSelectedSpecialService()
     * @param mixed[] $selectedSpecialService
     */
    public function __construct(array $selectedSpecialService = array())
    {
        $this
            ->setSelectedSpecialService($selectedSpecialService);
    }
    /**
     * Get SelectedSpecialService value
     * @return mixed[]|null
     */
    public function getSelectedSpecialService()
    {
        return $this->SelectedSpecialService;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectedSpecialService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedSpecialService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectedSpecialServiceForArrayConstraintsFromSetSelectedSpecialService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $selectedSpecialServicesSelectedSpecialServiceItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($selectedSpecialServicesSelectedSpecialServiceItem) ? get_class($selectedSpecialServicesSelectedSpecialServiceItem) : sprintf('%s(%s)', gettype($selectedSpecialServicesSelectedSpecialServiceItem), var_export($selectedSpecialServicesSelectedSpecialServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectedSpecialService property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectedSpecialService value
     * @throws \InvalidArgumentException
     * @param mixed[] $selectedSpecialService
     * @return \StructType\SelectedSpecialServices
     */
    public function setSelectedSpecialService(array $selectedSpecialService = array())
    {
        // validation for constraint: array
        if ('' !== ($selectedSpecialServiceArrayErrorMessage = self::validateSelectedSpecialServiceForArrayConstraintsFromSetSelectedSpecialService($selectedSpecialService))) {
            throw new \InvalidArgumentException($selectedSpecialServiceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($selectedSpecialService) && count($selectedSpecialService) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($selectedSpecialService)), __LINE__);
        }
        $this->SelectedSpecialService = $selectedSpecialService;
        return $this;
    }
    /**
     * Add item to SelectedSpecialService value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\SelectedSpecialServices
     */
    public function addToSelectedSpecialService($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The SelectedSpecialService property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->SelectedSpecialService) && count($this->SelectedSpecialService) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->SelectedSpecialService)), __LINE__);
        }
        $this->SelectedSpecialService[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SelectedSpecialServices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
