<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectedSailing StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains information related to the selected sailing. | Contains information related to the selected sailing. Typically the selected sailing is one of the sailings returned in the previous sailing availability response.
 * @subpackage Structs
 */
class SelectedSailing extends SailingBaseType
{
    /**
     * The VoyageID
     * Meta information extracted from the WSDL
     * - documentation: Specifies the cruise line unique identifier for a particular sailing.
     * - use: optional
     * @var string
     */
    public $VoyageID;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Specifies the status of the voyage. Refer to OpenTravel Code table Status (STS).
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The PortsOfCallQuantity
     * Meta information extracted from the WSDL
     * - documentation: Number of ports of call that the specific sailing has.
     * - use: optional
     * @var int
     */
    public $PortsOfCallQuantity;
    /**
     * The GroupCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies the group code. | Used for Character Strings, length 1 to 16.
     * - base: xs:string
     * - maxLength: 16
     * - minLength: 1
     * @var string
     */
    public $GroupCode;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The VendorCode
     * @var string
     */
    public $VendorCode;
    /**
     * The VendorName
     * @var string
     */
    public $VendorName;
    /**
     * The ShipCode
     * @var string
     */
    public $ShipCode;
    /**
     * The ShipName
     * @var string
     */
    public $ShipName;
    /**
     * The VendorCodeContext
     * @var string
     */
    public $VendorCodeContext;
    /**
     * Constructor method for SelectedSailing
     * @uses SelectedSailing::setVoyageID()
     * @uses SelectedSailing::setStatus()
     * @uses SelectedSailing::setPortsOfCallQuantity()
     * @uses SelectedSailing::setGroupCode()
     * @uses SelectedSailing::setStart()
     * @uses SelectedSailing::setDuration()
     * @uses SelectedSailing::setEnd()
     * @uses SelectedSailing::setVendorCode()
     * @uses SelectedSailing::setVendorName()
     * @uses SelectedSailing::setShipCode()
     * @uses SelectedSailing::setShipName()
     * @uses SelectedSailing::setVendorCodeContext()
     * @param string $voyageID
     * @param string $status
     * @param int $portsOfCallQuantity
     * @param string $groupCode
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $vendorCode
     * @param string $vendorName
     * @param string $shipCode
     * @param string $shipName
     * @param string $vendorCodeContext
     */
    public function __construct($voyageID = null, $status = null, $portsOfCallQuantity = null, $groupCode = null, $start = null, $duration = null, $end = null, $vendorCode = null, $vendorName = null, $shipCode = null, $shipName = null, $vendorCodeContext = null)
    {
        $this
            ->setVoyageID($voyageID)
            ->setStatus($status)
            ->setPortsOfCallQuantity($portsOfCallQuantity)
            ->setGroupCode($groupCode)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setVendorCode($vendorCode)
            ->setVendorName($vendorName)
            ->setShipCode($shipCode)
            ->setShipName($shipName)
            ->setVendorCodeContext($vendorCodeContext);
    }
    /**
     * Get VoyageID value
     * @return string|null
     */
    public function getVoyageID()
    {
        return $this->VoyageID;
    }
    /**
     * Set VoyageID value
     * @param string $voyageID
     * @return \StructType\SelectedSailing
     */
    public function setVoyageID($voyageID = null)
    {
        // validation for constraint: string
        if (!is_null($voyageID) && !is_string($voyageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voyageID, true), gettype($voyageID)), __LINE__);
        }
        $this->VoyageID = $voyageID;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\SelectedSailing
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get PortsOfCallQuantity value
     * @return int|null
     */
    public function getPortsOfCallQuantity()
    {
        return $this->PortsOfCallQuantity;
    }
    /**
     * Set PortsOfCallQuantity value
     * @param int $portsOfCallQuantity
     * @return \StructType\SelectedSailing
     */
    public function setPortsOfCallQuantity($portsOfCallQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($portsOfCallQuantity) && !(is_int($portsOfCallQuantity) || ctype_digit($portsOfCallQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($portsOfCallQuantity, true), gettype($portsOfCallQuantity)), __LINE__);
        }
        $this->PortsOfCallQuantity = $portsOfCallQuantity;
        return $this;
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \StructType\SelectedSailing
     */
    public function setGroupCode($groupCode = null)
    {
        // validation for constraint: string
        if (!is_null($groupCode) && !is_string($groupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupCode, true), gettype($groupCode)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($groupCode) && mb_strlen($groupCode) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($groupCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($groupCode) && mb_strlen($groupCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($groupCode)), __LINE__);
        }
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\SelectedSailing
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\SelectedSailing
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\SelectedSailing
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\SelectedSailing
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCode, true), gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get VendorName value
     * @return string|null
     */
    public function getVendorName()
    {
        return $this->VendorName;
    }
    /**
     * Set VendorName value
     * @param string $vendorName
     * @return \StructType\SelectedSailing
     */
    public function setVendorName($vendorName = null)
    {
        // validation for constraint: string
        if (!is_null($vendorName) && !is_string($vendorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorName, true), gettype($vendorName)), __LINE__);
        }
        $this->VendorName = $vendorName;
        return $this;
    }
    /**
     * Get ShipCode value
     * @return string|null
     */
    public function getShipCode()
    {
        return $this->ShipCode;
    }
    /**
     * Set ShipCode value
     * @param string $shipCode
     * @return \StructType\SelectedSailing
     */
    public function setShipCode($shipCode = null)
    {
        // validation for constraint: string
        if (!is_null($shipCode) && !is_string($shipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipCode, true), gettype($shipCode)), __LINE__);
        }
        $this->ShipCode = $shipCode;
        return $this;
    }
    /**
     * Get ShipName value
     * @return string|null
     */
    public function getShipName()
    {
        return $this->ShipName;
    }
    /**
     * Set ShipName value
     * @param string $shipName
     * @return \StructType\SelectedSailing
     */
    public function setShipName($shipName = null)
    {
        // validation for constraint: string
        if (!is_null($shipName) && !is_string($shipName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipName, true), gettype($shipName)), __LINE__);
        }
        $this->ShipName = $shipName;
        return $this;
    }
    /**
     * Get VendorCodeContext value
     * @return string|null
     */
    public function getVendorCodeContext()
    {
        return $this->VendorCodeContext;
    }
    /**
     * Set VendorCodeContext value
     * @param string $vendorCodeContext
     * @return \StructType\SelectedSailing
     */
    public function setVendorCodeContext($vendorCodeContext = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCodeContext) && !is_string($vendorCodeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCodeContext, true), gettype($vendorCodeContext)), __LINE__);
        }
        $this->VendorCodeContext = $vendorCodeContext;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SelectedSailing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
