<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectedPackages StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the selected packages.
 * @subpackage Structs
 */
class SelectedPackages extends AbstractStructBase
{
    /**
     * The SelectedPackage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SelectedPackage[]
     */
    public $SelectedPackage;
    /**
     * Constructor method for SelectedPackages
     * @uses SelectedPackages::setSelectedPackage()
     * @param \StructType\SelectedPackage[] $selectedPackage
     */
    public function __construct(array $selectedPackage = array())
    {
        $this
            ->setSelectedPackage($selectedPackage);
    }
    /**
     * Get SelectedPackage value
     * @return \StructType\SelectedPackage[]|null
     */
    public function getSelectedPackage()
    {
        return $this->SelectedPackage;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectedPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectedPackageForArrayConstraintsFromSetSelectedPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $selectedPackagesSelectedPackageItem) {
            // validation for constraint: itemType
            if (!$selectedPackagesSelectedPackageItem instanceof \StructType\SelectedPackage) {
                $invalidValues[] = is_object($selectedPackagesSelectedPackageItem) ? get_class($selectedPackagesSelectedPackageItem) : sprintf('%s(%s)', gettype($selectedPackagesSelectedPackageItem), var_export($selectedPackagesSelectedPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectedPackage property can only contain items of type \StructType\SelectedPackage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectedPackage value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedPackage[] $selectedPackage
     * @return \StructType\SelectedPackages
     */
    public function setSelectedPackage(array $selectedPackage = array())
    {
        // validation for constraint: array
        if ('' !== ($selectedPackageArrayErrorMessage = self::validateSelectedPackageForArrayConstraintsFromSetSelectedPackage($selectedPackage))) {
            throw new \InvalidArgumentException($selectedPackageArrayErrorMessage, __LINE__);
        }
        $this->SelectedPackage = $selectedPackage;
        return $this;
    }
    /**
     * Add item to SelectedPackage value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedPackage $item
     * @return \StructType\SelectedPackages
     */
    public function addToSelectedPackage(\StructType\SelectedPackage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectedPackage) {
            throw new \InvalidArgumentException(sprintf('The SelectedPackage property can only contain items of type \StructType\SelectedPackage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectedPackage[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SelectedPackages
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
