<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatZoneSummaryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Summary information related to a zone of seating.
 * @subpackage Structs
 */
class SeatZoneSummaryType extends AbstractStructBase
{
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: The unique seat zone ID.
     * - use: optional
     * @var string
     */
    public $ID;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: The unique seat zone number or code.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the seat zone.
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: The seat zone description.
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The TotalSeatQty
     * Meta information extracted from the WSDL
     * - documentation: The total quantity of seats in the seat zone, including both available and reserved seats.
     * - use: optional
     * @var int
     */
    public $TotalSeatQty;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * Constructor method for SeatZoneSummaryType
     * @uses SeatZoneSummaryType::setTPA_Extensions()
     * @uses SeatZoneSummaryType::setID()
     * @uses SeatZoneSummaryType::setCode()
     * @uses SeatZoneSummaryType::setName()
     * @uses SeatZoneSummaryType::setDescription()
     * @uses SeatZoneSummaryType::setTotalSeatQty()
     * @uses SeatZoneSummaryType::setType()
     * @param mixed $tPA_Extensions
     * @param string $iD
     * @param string $code
     * @param string $name
     * @param string $description
     * @param int $totalSeatQty
     * @param string $type
     */
    public function __construct($tPA_Extensions = null, $iD = null, $code = null, $name = null, $description = null, $totalSeatQty = null, $type = null)
    {
        $this
            ->setTPA_Extensions($tPA_Extensions)
            ->setID($iD)
            ->setCode($code)
            ->setName($name)
            ->setDescription($description)
            ->setTotalSeatQty($totalSeatQty)
            ->setType($type);
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\SeatZoneSummaryType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\SeatZoneSummaryType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\SeatZoneSummaryType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\SeatZoneSummaryType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\SeatZoneSummaryType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get TotalSeatQty value
     * @return int|null
     */
    public function getTotalSeatQty()
    {
        return $this->TotalSeatQty;
    }
    /**
     * Set TotalSeatQty value
     * @param int $totalSeatQty
     * @return \StructType\SeatZoneSummaryType
     */
    public function setTotalSeatQty($totalSeatQty = null)
    {
        // validation for constraint: int
        if (!is_null($totalSeatQty) && !(is_int($totalSeatQty) || ctype_digit($totalSeatQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalSeatQty, true), gettype($totalSeatQty)), __LINE__);
        }
        $this->TotalSeatQty = $totalSeatQty;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\SeatZoneSummaryType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatZoneSummaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
