<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatZoneDetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Detailed information related to a zone of seating.
 * @subpackage Structs
 */
class SeatZoneDetailType extends AbstractStructBase
{
    /**
     * The SeatTypeDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\SeatTypeDetail[]
     */
    public $SeatTypeDetail;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: The unique seat zone ID.
     * - use: optional
     * @var string
     */
    public $ID;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: The unique seat zone number or code.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the seat zone.
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: The seat zone description.
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The TotalSeatQty
     * Meta information extracted from the WSDL
     * - documentation: The total quantity of seats in the seat zone, including both available and reserved seats.
     * - use: optional
     * @var int
     */
    public $TotalSeatQty;
    /**
     * Constructor method for SeatZoneDetailType
     * @uses SeatZoneDetailType::setSeatTypeDetail()
     * @uses SeatZoneDetailType::setTPA_Extensions()
     * @uses SeatZoneDetailType::setID()
     * @uses SeatZoneDetailType::setCode()
     * @uses SeatZoneDetailType::setName()
     * @uses SeatZoneDetailType::setDescription()
     * @uses SeatZoneDetailType::setTotalSeatQty()
     * @param \StructType\SeatTypeDetail[] $seatTypeDetail
     * @param mixed $tPA_Extensions
     * @param string $iD
     * @param string $code
     * @param string $name
     * @param string $description
     * @param int $totalSeatQty
     */
    public function __construct(array $seatTypeDetail = array(), $tPA_Extensions = null, $iD = null, $code = null, $name = null, $description = null, $totalSeatQty = null)
    {
        $this
            ->setSeatTypeDetail($seatTypeDetail)
            ->setTPA_Extensions($tPA_Extensions)
            ->setID($iD)
            ->setCode($code)
            ->setName($name)
            ->setDescription($description)
            ->setTotalSeatQty($totalSeatQty);
    }
    /**
     * Get SeatTypeDetail value
     * @return \StructType\SeatTypeDetail[]|null
     */
    public function getSeatTypeDetail()
    {
        return $this->SeatTypeDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatTypeDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatTypeDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatTypeDetailForArrayConstraintsFromSetSeatTypeDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatZoneDetailTypeSeatTypeDetailItem) {
            // validation for constraint: itemType
            if (!$seatZoneDetailTypeSeatTypeDetailItem instanceof \StructType\SeatTypeDetail) {
                $invalidValues[] = is_object($seatZoneDetailTypeSeatTypeDetailItem) ? get_class($seatZoneDetailTypeSeatTypeDetailItem) : sprintf('%s(%s)', gettype($seatZoneDetailTypeSeatTypeDetailItem), var_export($seatZoneDetailTypeSeatTypeDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatTypeDetail property can only contain items of type \StructType\SeatTypeDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatTypeDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatTypeDetail[] $seatTypeDetail
     * @return \StructType\SeatZoneDetailType
     */
    public function setSeatTypeDetail(array $seatTypeDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($seatTypeDetailArrayErrorMessage = self::validateSeatTypeDetailForArrayConstraintsFromSetSeatTypeDetail($seatTypeDetail))) {
            throw new \InvalidArgumentException($seatTypeDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($seatTypeDetail) && count($seatTypeDetail) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($seatTypeDetail)), __LINE__);
        }
        $this->SeatTypeDetail = $seatTypeDetail;
        return $this;
    }
    /**
     * Add item to SeatTypeDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatTypeDetail $item
     * @return \StructType\SeatZoneDetailType
     */
    public function addToSeatTypeDetail(\StructType\SeatTypeDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SeatTypeDetail) {
            throw new \InvalidArgumentException(sprintf('The SeatTypeDetail property can only contain items of type \StructType\SeatTypeDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->SeatTypeDetail) && count($this->SeatTypeDetail) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->SeatTypeDetail)), __LINE__);
        }
        $this->SeatTypeDetail[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\SeatZoneDetailType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\SeatZoneDetailType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\SeatZoneDetailType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\SeatZoneDetailType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\SeatZoneDetailType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get TotalSeatQty value
     * @return int|null
     */
    public function getTotalSeatQty()
    {
        return $this->TotalSeatQty;
    }
    /**
     * Set TotalSeatQty value
     * @param int $totalSeatQty
     * @return \StructType\SeatZoneDetailType
     */
    public function setTotalSeatQty($totalSeatQty = null)
    {
        // validation for constraint: int
        if (!is_null($totalSeatQty) && !(is_int($totalSeatQty) || ctype_digit($totalSeatQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalSeatQty, true), gettype($totalSeatQty)), __LINE__);
        }
        $this->TotalSeatQty = $totalSeatQty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatZoneDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
