<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatTypeDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: Seat zone seat details, including seat type, total quantity and available quantity.
 * @subpackage Structs
 */
class SeatTypeDetail extends AbstractStructBase
{
    /**
     * The Features
     * Meta information extracted from the WSDL
     * - documentation: An extensible list of seat features for this seat in the seat zone. Select an item from the list or use the Other_ list value and enter a seat feature in the @extension attribute that is known to trading partners.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Features;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The TotalQty
     * Meta information extracted from the WSDL
     * - documentation: The total quantity of all seats for the specified seat type in the seat zone.
     * - use: optional
     * @var int
     */
    public $TotalQty;
    /**
     * The AvailableQty
     * Meta information extracted from the WSDL
     * - documentation: The quantity of all available seats for the specified seat type in the seat zone.
     * - use: optional
     * @var int
     */
    public $AvailableQty;
    /**
     * Constructor method for SeatTypeDetail
     * @uses SeatTypeDetail::setFeatures()
     * @uses SeatTypeDetail::setType()
     * @uses SeatTypeDetail::setTotalQty()
     * @uses SeatTypeDetail::setAvailableQty()
     * @param mixed[] $features
     * @param string $type
     * @param int $totalQty
     * @param int $availableQty
     */
    public function __construct(array $features = array(), $type = null, $totalQty = null, $availableQty = null)
    {
        $this
            ->setFeatures($features)
            ->setType($type)
            ->setTotalQty($totalQty)
            ->setAvailableQty($availableQty);
    }
    /**
     * Get Features value
     * @return mixed[]|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * This method is responsible for validating the values passed to the setFeatures method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFeatures method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeaturesForArrayConstraintsFromSetFeatures(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatTypeDetailFeaturesItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($seatTypeDetailFeaturesItem) ? get_class($seatTypeDetailFeaturesItem) : sprintf('%s(%s)', gettype($seatTypeDetailFeaturesItem), var_export($seatTypeDetailFeaturesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Features property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Features value
     * @throws \InvalidArgumentException
     * @param mixed[] $features
     * @return \StructType\SeatTypeDetail
     */
    public function setFeatures(array $features = array())
    {
        // validation for constraint: array
        if ('' !== ($featuresArrayErrorMessage = self::validateFeaturesForArrayConstraintsFromSetFeatures($features))) {
            throw new \InvalidArgumentException($featuresArrayErrorMessage, __LINE__);
        }
        $this->Features = $features;
        return $this;
    }
    /**
     * Add item to Features value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\SeatTypeDetail
     */
    public function addToFeatures($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Features property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Features[] = $item;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\SeatTypeDetail
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get TotalQty value
     * @return int|null
     */
    public function getTotalQty()
    {
        return $this->TotalQty;
    }
    /**
     * Set TotalQty value
     * @param int $totalQty
     * @return \StructType\SeatTypeDetail
     */
    public function setTotalQty($totalQty = null)
    {
        // validation for constraint: int
        if (!is_null($totalQty) && !(is_int($totalQty) || ctype_digit($totalQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalQty, true), gettype($totalQty)), __LINE__);
        }
        $this->TotalQty = $totalQty;
        return $this;
    }
    /**
     * Get AvailableQty value
     * @return int|null
     */
    public function getAvailableQty()
    {
        return $this->AvailableQty;
    }
    /**
     * Set AvailableQty value
     * @param int $availableQty
     * @return \StructType\SeatTypeDetail
     */
    public function setAvailableQty($availableQty = null)
    {
        // validation for constraint: int
        if (!is_null($availableQty) && !(is_int($availableQty) || ctype_digit($availableQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availableQty, true), gettype($availableQty)), __LINE__);
        }
        $this->AvailableQty = $availableQty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatTypeDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
