<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatSummaryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Describes summary seat information, including number and characteristics.
 * @subpackage Structs
 */
class SeatSummaryType extends AbstractStructBase
{
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique ID for this seat that may be used elsewhere in the message.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The SeatSection
     * Meta information extracted from the WSDL
     * - documentation: Actual seat number within a particular row, typically A, B etc.
     * - use: optional
     * @var string
     */
    public $SeatSection;
    /**
     * The SeatNumber
     * Meta information extracted from the WSDL
     * - documentation: The seat number that includes row number and seat section, e.g. "2C".
     * - use: optional
     * @var string
     */
    public $SeatNumber;
    /**
     * The RowNumber
     * Meta information extracted from the WSDL
     * - documentation: Specifies the actual (physical) row number in the seat map.
     * - use: optional
     * @var int
     */
    public $RowNumber;
    /**
     * The AirBookDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Allows that a seat may be assigned a class code.
     * - use: optional
     * @var string
     */
    public $AirBookDesigCode;
    /**
     * The SeatSequenceNumber
     * Meta information extracted from the WSDL
     * - documentation: The absolute sequence of seat within a row that describes seats and locations outside the physical sequence, e.g. aisles, galleys or jumpseats.
     * - use: optional
     * @var int
     */
    public $SeatSequenceNumber;
    /**
     * The AdvancePurchaseInd
     * Meta information extracted from the WSDL
     * - documentation: If true, advanced purchase is required for this seat.
     * - use: optional
     * @var bool
     */
    public $AdvancePurchaseInd;
    /**
     * The AvailableInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this seat is available.
     * - use: optional
     * @var bool
     */
    public $AvailableInd;
    /**
     * The InoperativeInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this seat is not operational.
     * - use: optional
     * @var bool
     */
    public $InoperativeInd;
    /**
     * The OccupiedInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this seat is occupied and/or already reserved.
     * - use: optional
     * @var bool
     */
    public $OccupiedInd;
    /**
     * Constructor method for SeatSummaryType
     * @uses SeatSummaryType::setTPA_Extensions()
     * @uses SeatSummaryType::setRPH()
     * @uses SeatSummaryType::setSeatSection()
     * @uses SeatSummaryType::setSeatNumber()
     * @uses SeatSummaryType::setRowNumber()
     * @uses SeatSummaryType::setAirBookDesigCode()
     * @uses SeatSummaryType::setSeatSequenceNumber()
     * @uses SeatSummaryType::setAdvancePurchaseInd()
     * @uses SeatSummaryType::setAvailableInd()
     * @uses SeatSummaryType::setInoperativeInd()
     * @uses SeatSummaryType::setOccupiedInd()
     * @param mixed $tPA_Extensions
     * @param string $rPH
     * @param string $seatSection
     * @param string $seatNumber
     * @param int $rowNumber
     * @param string $airBookDesigCode
     * @param int $seatSequenceNumber
     * @param bool $advancePurchaseInd
     * @param bool $availableInd
     * @param bool $inoperativeInd
     * @param bool $occupiedInd
     */
    public function __construct($tPA_Extensions = null, $rPH = null, $seatSection = null, $seatNumber = null, $rowNumber = null, $airBookDesigCode = null, $seatSequenceNumber = null, $advancePurchaseInd = null, $availableInd = null, $inoperativeInd = null, $occupiedInd = null)
    {
        $this
            ->setTPA_Extensions($tPA_Extensions)
            ->setRPH($rPH)
            ->setSeatSection($seatSection)
            ->setSeatNumber($seatNumber)
            ->setRowNumber($rowNumber)
            ->setAirBookDesigCode($airBookDesigCode)
            ->setSeatSequenceNumber($seatSequenceNumber)
            ->setAdvancePurchaseInd($advancePurchaseInd)
            ->setAvailableInd($availableInd)
            ->setInoperativeInd($inoperativeInd)
            ->setOccupiedInd($occupiedInd);
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\SeatSummaryType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\SeatSummaryType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get SeatSection value
     * @return string|null
     */
    public function getSeatSection()
    {
        return $this->SeatSection;
    }
    /**
     * Set SeatSection value
     * @param string $seatSection
     * @return \StructType\SeatSummaryType
     */
    public function setSeatSection($seatSection = null)
    {
        // validation for constraint: string
        if (!is_null($seatSection) && !is_string($seatSection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatSection, true), gettype($seatSection)), __LINE__);
        }
        $this->SeatSection = $seatSection;
        return $this;
    }
    /**
     * Get SeatNumber value
     * @return string|null
     */
    public function getSeatNumber()
    {
        return $this->SeatNumber;
    }
    /**
     * Set SeatNumber value
     * @param string $seatNumber
     * @return \StructType\SeatSummaryType
     */
    public function setSeatNumber($seatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seatNumber) && !is_string($seatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatNumber, true), gettype($seatNumber)), __LINE__);
        }
        $this->SeatNumber = $seatNumber;
        return $this;
    }
    /**
     * Get RowNumber value
     * @return int|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\SeatSummaryType
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get AirBookDesigCode value
     * @return string|null
     */
    public function getAirBookDesigCode()
    {
        return $this->AirBookDesigCode;
    }
    /**
     * Set AirBookDesigCode value
     * @param string $airBookDesigCode
     * @return \StructType\SeatSummaryType
     */
    public function setAirBookDesigCode($airBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($airBookDesigCode) && !is_string($airBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airBookDesigCode, true), gettype($airBookDesigCode)), __LINE__);
        }
        $this->AirBookDesigCode = $airBookDesigCode;
        return $this;
    }
    /**
     * Get SeatSequenceNumber value
     * @return int|null
     */
    public function getSeatSequenceNumber()
    {
        return $this->SeatSequenceNumber;
    }
    /**
     * Set SeatSequenceNumber value
     * @param int $seatSequenceNumber
     * @return \StructType\SeatSummaryType
     */
    public function setSeatSequenceNumber($seatSequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($seatSequenceNumber) && !(is_int($seatSequenceNumber) || ctype_digit($seatSequenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatSequenceNumber, true), gettype($seatSequenceNumber)), __LINE__);
        }
        $this->SeatSequenceNumber = $seatSequenceNumber;
        return $this;
    }
    /**
     * Get AdvancePurchaseInd value
     * @return bool|null
     */
    public function getAdvancePurchaseInd()
    {
        return $this->AdvancePurchaseInd;
    }
    /**
     * Set AdvancePurchaseInd value
     * @param bool $advancePurchaseInd
     * @return \StructType\SeatSummaryType
     */
    public function setAdvancePurchaseInd($advancePurchaseInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($advancePurchaseInd) && !is_bool($advancePurchaseInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($advancePurchaseInd, true), gettype($advancePurchaseInd)), __LINE__);
        }
        $this->AdvancePurchaseInd = $advancePurchaseInd;
        return $this;
    }
    /**
     * Get AvailableInd value
     * @return bool|null
     */
    public function getAvailableInd()
    {
        return $this->AvailableInd;
    }
    /**
     * Set AvailableInd value
     * @param bool $availableInd
     * @return \StructType\SeatSummaryType
     */
    public function setAvailableInd($availableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableInd) && !is_bool($availableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableInd, true), gettype($availableInd)), __LINE__);
        }
        $this->AvailableInd = $availableInd;
        return $this;
    }
    /**
     * Get InoperativeInd value
     * @return bool|null
     */
    public function getInoperativeInd()
    {
        return $this->InoperativeInd;
    }
    /**
     * Set InoperativeInd value
     * @param bool $inoperativeInd
     * @return \StructType\SeatSummaryType
     */
    public function setInoperativeInd($inoperativeInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($inoperativeInd) && !is_bool($inoperativeInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inoperativeInd, true), gettype($inoperativeInd)), __LINE__);
        }
        $this->InoperativeInd = $inoperativeInd;
        return $this;
    }
    /**
     * Get OccupiedInd value
     * @return bool|null
     */
    public function getOccupiedInd()
    {
        return $this->OccupiedInd;
    }
    /**
     * Set OccupiedInd value
     * @param bool $occupiedInd
     * @return \StructType\SeatSummaryType
     */
    public function setOccupiedInd($occupiedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($occupiedInd) && !is_bool($occupiedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($occupiedInd, true), gettype($occupiedInd)), __LINE__);
        }
        $this->OccupiedInd = $occupiedInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatSummaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
