<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatIdentificationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines a specific seat on the train.
 * @subpackage Structs
 */
class SeatIdentificationType extends AbstractStructBase
{
    /**
     * The CarNumber
     * Meta information extracted from the WSDL
     * - documentation: The number of the train carriage or car.
     * - use: required
     * @var int
     */
    public $CarNumber;
    /**
     * The SeatNumber
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $SeatNumber;
    /**
     * The Deck
     * Meta information extracted from the WSDL
     * - documentation: The preferred deck number that the seat is located on, such as "Lower Level" and "Upper Level."
     * @var string
     */
    public $Deck;
    /**
     * Constructor method for SeatIdentificationType
     * @uses SeatIdentificationType::setCarNumber()
     * @uses SeatIdentificationType::setSeatNumber()
     * @uses SeatIdentificationType::setDeck()
     * @param int $carNumber
     * @param string $seatNumber
     * @param string $deck
     */
    public function __construct($carNumber = null, $seatNumber = null, $deck = null)
    {
        $this
            ->setCarNumber($carNumber)
            ->setSeatNumber($seatNumber)
            ->setDeck($deck);
    }
    /**
     * Get CarNumber value
     * @return int
     */
    public function getCarNumber()
    {
        return $this->CarNumber;
    }
    /**
     * Set CarNumber value
     * @param int $carNumber
     * @return \StructType\SeatIdentificationType
     */
    public function setCarNumber($carNumber = null)
    {
        // validation for constraint: int
        if (!is_null($carNumber) && !(is_int($carNumber) || ctype_digit($carNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($carNumber, true), gettype($carNumber)), __LINE__);
        }
        $this->CarNumber = $carNumber;
        return $this;
    }
    /**
     * Get SeatNumber value
     * @return string
     */
    public function getSeatNumber()
    {
        return $this->SeatNumber;
    }
    /**
     * Set SeatNumber value
     * @param string $seatNumber
     * @return \StructType\SeatIdentificationType
     */
    public function setSeatNumber($seatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seatNumber) && !is_string($seatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatNumber, true), gettype($seatNumber)), __LINE__);
        }
        $this->SeatNumber = $seatNumber;
        return $this;
    }
    /**
     * Get Deck value
     * @return string|null
     */
    public function getDeck()
    {
        return $this->Deck;
    }
    /**
     * Set Deck value
     * @uses \EnumType\DeckType::valueIsValid()
     * @uses \EnumType\DeckType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deck
     * @return \StructType\SeatIdentificationType
     */
    public function setDeck($deck = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeckType::valueIsValid($deck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DeckType', is_array($deck) ? implode(', ', $deck) : var_export($deck, true), implode(', ', \EnumType\DeckType::getValidValues())), __LINE__);
        }
        $this->Deck = $deck;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatIdentificationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
