<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatDetails StructType
 * Meta information extracted from the WSDL
 * - documentation: Object to hold the seat details that is to be requested.
 * @subpackage Structs
 */
class SeatDetails extends AbstractStructBase
{
    /**
     * The CabinClass
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\CabinClass[]
     */
    public $CabinClass;
    /**
     * The ResBookDesignations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResBookDesignations
     */
    public $ResBookDesignations;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: Fare basis code associated with the seat that may be associated with a flight segment.
     * - minOccurs: 0
     * @var mixed
     */
    public $FareBasisCode;
    /**
     * The SeatUpgradeInd
     * Meta information extracted from the WSDL
     * - documentation: false | SeatUpgrade will be set to true if the passenger is looking for an upgrade and the seat map response expected is after the upgrade, if applicable.
     * - use: optional
     * @var bool
     */
    public $SeatUpgradeInd;
    /**
     * Constructor method for SeatDetails
     * @uses SeatDetails::setCabinClass()
     * @uses SeatDetails::setResBookDesignations()
     * @uses SeatDetails::setFareBasisCode()
     * @uses SeatDetails::setSeatUpgradeInd()
     * @param \StructType\CabinClass[] $cabinClass
     * @param \StructType\ResBookDesignations $resBookDesignations
     * @param mixed $fareBasisCode
     * @param bool $seatUpgradeInd
     */
    public function __construct(array $cabinClass = array(), \StructType\ResBookDesignations $resBookDesignations = null, $fareBasisCode = null, $seatUpgradeInd = null)
    {
        $this
            ->setCabinClass($cabinClass)
            ->setResBookDesignations($resBookDesignations)
            ->setFareBasisCode($fareBasisCode)
            ->setSeatUpgradeInd($seatUpgradeInd);
    }
    /**
     * Get CabinClass value
     * @return \StructType\CabinClass[]|null
     */
    public function getCabinClass()
    {
        return $this->CabinClass;
    }
    /**
     * This method is responsible for validating the values passed to the setCabinClass method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabinClass method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCabinClassForArrayConstraintsFromSetCabinClass(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $seatDetailsCabinClassItem) {
            // validation for constraint: itemType
            if (!$seatDetailsCabinClassItem instanceof \StructType\CabinClass) {
                $invalidValues[] = is_object($seatDetailsCabinClassItem) ? get_class($seatDetailsCabinClassItem) : sprintf('%s(%s)', gettype($seatDetailsCabinClassItem), var_export($seatDetailsCabinClassItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CabinClass property can only contain items of type \StructType\CabinClass, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CabinClass value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinClass[] $cabinClass
     * @return \StructType\SeatDetails
     */
    public function setCabinClass(array $cabinClass = array())
    {
        // validation for constraint: array
        if ('' !== ($cabinClassArrayErrorMessage = self::validateCabinClassForArrayConstraintsFromSetCabinClass($cabinClass))) {
            throw new \InvalidArgumentException($cabinClassArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($cabinClass) && count($cabinClass) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($cabinClass)), __LINE__);
        }
        $this->CabinClass = $cabinClass;
        return $this;
    }
    /**
     * Add item to CabinClass value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinClass $item
     * @return \StructType\SeatDetails
     */
    public function addToCabinClass(\StructType\CabinClass $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CabinClass) {
            throw new \InvalidArgumentException(sprintf('The CabinClass property can only contain items of type \StructType\CabinClass, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->CabinClass) && count($this->CabinClass) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->CabinClass)), __LINE__);
        }
        $this->CabinClass[] = $item;
        return $this;
    }
    /**
     * Get ResBookDesignations value
     * @return \StructType\ResBookDesignations|null
     */
    public function getResBookDesignations()
    {
        return $this->ResBookDesignations;
    }
    /**
     * Set ResBookDesignations value
     * @param \StructType\ResBookDesignations $resBookDesignations
     * @return \StructType\SeatDetails
     */
    public function setResBookDesignations(\StructType\ResBookDesignations $resBookDesignations = null)
    {
        $this->ResBookDesignations = $resBookDesignations;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return mixed|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param mixed $fareBasisCode
     * @return \StructType\SeatDetails
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get SeatUpgradeInd value
     * @return bool|null
     */
    public function getSeatUpgradeInd()
    {
        return $this->SeatUpgradeInd;
    }
    /**
     * Set SeatUpgradeInd value
     * @param bool $seatUpgradeInd
     * @return \StructType\SeatDetails
     */
    public function setSeatUpgradeInd($seatUpgradeInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($seatUpgradeInd) && !is_bool($seatUpgradeInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($seatUpgradeInd, true), gettype($seatUpgradeInd)), __LINE__);
        }
        $this->SeatUpgradeInd = $seatUpgradeInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
