<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatDetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines information about a seat on a train.
 * @subpackage Structs
 */
class SeatDetailType extends \EnumType\SeatAccommodationType
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: The seat number.
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - documentation: The seat position, such as Window, Aisle and Table.
     * - use: optional
     * @var string
     */
    public $Position;
    /**
     * The Direction
     * Meta information extracted from the WSDL
     * - documentation: The seat direction, such as Facing and Back.
     * - use: optional
     * @var string
     */
    public $Direction;
    /**
     * Constructor method for SeatDetailType
     * @uses SeatDetailType::setNumber()
     * @uses SeatDetailType::setPosition()
     * @uses SeatDetailType::setDirection()
     * @param string $number
     * @param string $position
     * @param string $direction
     */
    public function __construct($number = null, $position = null, $direction = null)
    {
        $this
            ->setNumber($number)
            ->setPosition($position)
            ->setDirection($direction);
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \StructType\SeatDetailType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Position value
     * @return string|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @uses \EnumType\SeatPositionType::valueIsValid()
     * @uses \EnumType\SeatPositionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $position
     * @return \StructType\SeatDetailType
     */
    public function setPosition($position = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SeatPositionType::valueIsValid($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SeatPositionType', is_array($position) ? implode(', ', $position) : var_export($position, true), implode(', ', \EnumType\SeatPositionType::getValidValues())), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @uses \EnumType\SeatDirectionType::valueIsValid()
     * @uses \EnumType\SeatDirectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \StructType\SeatDetailType
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SeatDirectionType::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SeatDirectionType', is_array($direction) ? implode(', ', $direction) : var_export($direction, true), implode(', ', \EnumType\SeatDirectionType::getValidValues())), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeatDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
