<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchQualifierType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies the loyalty membership of a guest or prospect. | Specifies the fare and group codes. | Contains the berth and price category codes. | Search qualifiers that can be used in cruise availability/fare/category to avail special
 * search data.
 * @subpackage Structs
 */
class SearchQualifierType extends AbstractStructBase
{
    /**
     * The ReservationID
     * Meta information extracted from the WSDL
     * - documentation: Specifies the passenger's reservation number.
     * - minOccurs: 0
     * @var mixed
     */
    public $ReservationID;
    /**
     * The Residency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Residency
     */
    public $Residency;
    /**
     * The PriceRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PriceRange
     */
    public $PriceRange;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Status[]
     */
    public $Status;
    /**
     * The Dining
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Dining
     */
    public $Dining;
    /**
     * The MultimodalOffer
     * Meta information extracted from the WSDL
     * - documentation: Multimodal offer influencers.
     * - minOccurs: 0
     * @var mixed
     */
    public $MultimodalOffer;
    /**
     * The CabinNumber
     * Meta information extracted from the WSDL
     * - documentation: Specifies the cabin number.
     * - use: optional
     * @var string
     */
    public $CabinNumber;
    /**
     * The HeldIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates the CabinNumber has a hold on it. When false, the CabinNumber does not have a hold.
     * - use: optional
     * @var bool
     */
    public $HeldIndicator;
    /**
     * The MaxOccupancy
     * Meta information extracted from the WSDL
     * - documentation: Specifies the Max occupancy of the Cabin.
     * - use: optional
     * @var int
     */
    public $MaxOccupancy;
    /**
     * The CategoryLocation
     * Meta information extracted from the WSDL
     * - documentation: Specifies the cabin category location (e.g., inside, outside).
     * - use: optional
     * @var string
     */
    public $CategoryLocation;
    /**
     * The SortOrderCode
     * Meta information extracted from the WSDL
     * - documentation: Specifies the order in which the response information should be sorted. Refer to OpenTravel Code List Sort Order (SOC).
     * - use: optional
     * @var string
     */
    public $SortOrderCode;
    /**
     * Constructor method for SearchQualifierType
     * @uses SearchQualifierType::setReservationID()
     * @uses SearchQualifierType::setResidency()
     * @uses SearchQualifierType::setPriceRange()
     * @uses SearchQualifierType::setStatus()
     * @uses SearchQualifierType::setDining()
     * @uses SearchQualifierType::setMultimodalOffer()
     * @uses SearchQualifierType::setCabinNumber()
     * @uses SearchQualifierType::setHeldIndicator()
     * @uses SearchQualifierType::setMaxOccupancy()
     * @uses SearchQualifierType::setCategoryLocation()
     * @uses SearchQualifierType::setSortOrderCode()
     * @param mixed $reservationID
     * @param \StructType\Residency $residency
     * @param \StructType\PriceRange $priceRange
     * @param \StructType\Status[] $status
     * @param \StructType\Dining $dining
     * @param mixed $multimodalOffer
     * @param string $cabinNumber
     * @param bool $heldIndicator
     * @param int $maxOccupancy
     * @param string $categoryLocation
     * @param string $sortOrderCode
     */
    public function __construct($reservationID = null, \StructType\Residency $residency = null, \StructType\PriceRange $priceRange = null, array $status = array(), \StructType\Dining $dining = null, $multimodalOffer = null, $cabinNumber = null, $heldIndicator = null, $maxOccupancy = null, $categoryLocation = null, $sortOrderCode = null)
    {
        $this
            ->setReservationID($reservationID)
            ->setResidency($residency)
            ->setPriceRange($priceRange)
            ->setStatus($status)
            ->setDining($dining)
            ->setMultimodalOffer($multimodalOffer)
            ->setCabinNumber($cabinNumber)
            ->setHeldIndicator($heldIndicator)
            ->setMaxOccupancy($maxOccupancy)
            ->setCategoryLocation($categoryLocation)
            ->setSortOrderCode($sortOrderCode);
    }
    /**
     * Get ReservationID value
     * @return mixed|null
     */
    public function getReservationID()
    {
        return $this->ReservationID;
    }
    /**
     * Set ReservationID value
     * @param mixed $reservationID
     * @return \StructType\SearchQualifierType
     */
    public function setReservationID($reservationID = null)
    {
        $this->ReservationID = $reservationID;
        return $this;
    }
    /**
     * Get Residency value
     * @return \StructType\Residency|null
     */
    public function getResidency()
    {
        return $this->Residency;
    }
    /**
     * Set Residency value
     * @param \StructType\Residency $residency
     * @return \StructType\SearchQualifierType
     */
    public function setResidency(\StructType\Residency $residency = null)
    {
        $this->Residency = $residency;
        return $this;
    }
    /**
     * Get PriceRange value
     * @return \StructType\PriceRange|null
     */
    public function getPriceRange()
    {
        return $this->PriceRange;
    }
    /**
     * Set PriceRange value
     * @param \StructType\PriceRange $priceRange
     * @return \StructType\SearchQualifierType
     */
    public function setPriceRange(\StructType\PriceRange $priceRange = null)
    {
        $this->PriceRange = $priceRange;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Status[]|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * This method is responsible for validating the values passed to the setStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatusForArrayConstraintsFromSetStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchQualifierTypeStatusItem) {
            // validation for constraint: itemType
            if (!$searchQualifierTypeStatusItem instanceof \StructType\Status) {
                $invalidValues[] = is_object($searchQualifierTypeStatusItem) ? get_class($searchQualifierTypeStatusItem) : sprintf('%s(%s)', gettype($searchQualifierTypeStatusItem), var_export($searchQualifierTypeStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Status property can only contain items of type \StructType\Status, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Status value
     * @throws \InvalidArgumentException
     * @param \StructType\Status[] $status
     * @return \StructType\SearchQualifierType
     */
    public function setStatus(array $status = array())
    {
        // validation for constraint: array
        if ('' !== ($statusArrayErrorMessage = self::validateStatusForArrayConstraintsFromSetStatus($status))) {
            throw new \InvalidArgumentException($statusArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($status) && count($status) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Add item to Status value
     * @throws \InvalidArgumentException
     * @param \StructType\Status $item
     * @return \StructType\SearchQualifierType
     */
    public function addToStatus(\StructType\Status $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Status) {
            throw new \InvalidArgumentException(sprintf('The Status property can only contain items of type \StructType\Status, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Status) && count($this->Status) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Status)), __LINE__);
        }
        $this->Status[] = $item;
        return $this;
    }
    /**
     * Get Dining value
     * @return \StructType\Dining|null
     */
    public function getDining()
    {
        return $this->Dining;
    }
    /**
     * Set Dining value
     * @param \StructType\Dining $dining
     * @return \StructType\SearchQualifierType
     */
    public function setDining(\StructType\Dining $dining = null)
    {
        $this->Dining = $dining;
        return $this;
    }
    /**
     * Get MultimodalOffer value
     * @return mixed|null
     */
    public function getMultimodalOffer()
    {
        return $this->MultimodalOffer;
    }
    /**
     * Set MultimodalOffer value
     * @param mixed $multimodalOffer
     * @return \StructType\SearchQualifierType
     */
    public function setMultimodalOffer($multimodalOffer = null)
    {
        $this->MultimodalOffer = $multimodalOffer;
        return $this;
    }
    /**
     * Get CabinNumber value
     * @return string|null
     */
    public function getCabinNumber()
    {
        return $this->CabinNumber;
    }
    /**
     * Set CabinNumber value
     * @param string $cabinNumber
     * @return \StructType\SearchQualifierType
     */
    public function setCabinNumber($cabinNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cabinNumber) && !is_string($cabinNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinNumber, true), gettype($cabinNumber)), __LINE__);
        }
        $this->CabinNumber = $cabinNumber;
        return $this;
    }
    /**
     * Get HeldIndicator value
     * @return bool|null
     */
    public function getHeldIndicator()
    {
        return $this->HeldIndicator;
    }
    /**
     * Set HeldIndicator value
     * @param bool $heldIndicator
     * @return \StructType\SearchQualifierType
     */
    public function setHeldIndicator($heldIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($heldIndicator) && !is_bool($heldIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($heldIndicator, true), gettype($heldIndicator)), __LINE__);
        }
        $this->HeldIndicator = $heldIndicator;
        return $this;
    }
    /**
     * Get MaxOccupancy value
     * @return int|null
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param int $maxOccupancy
     * @return \StructType\SearchQualifierType
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxOccupancy) && !(is_int($maxOccupancy) || ctype_digit($maxOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxOccupancy, true), gettype($maxOccupancy)), __LINE__);
        }
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Get CategoryLocation value
     * @return string|null
     */
    public function getCategoryLocation()
    {
        return $this->CategoryLocation;
    }
    /**
     * Set CategoryLocation value
     * @uses \EnumType\CategoryLocationType::valueIsValid()
     * @uses \EnumType\CategoryLocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $categoryLocation
     * @return \StructType\SearchQualifierType
     */
    public function setCategoryLocation($categoryLocation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CategoryLocationType::valueIsValid($categoryLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CategoryLocationType', is_array($categoryLocation) ? implode(', ', $categoryLocation) : var_export($categoryLocation, true), implode(', ', \EnumType\CategoryLocationType::getValidValues())), __LINE__);
        }
        $this->CategoryLocation = $categoryLocation;
        return $this;
    }
    /**
     * Get SortOrderCode value
     * @return string|null
     */
    public function getSortOrderCode()
    {
        return $this->SortOrderCode;
    }
    /**
     * Set SortOrderCode value
     * @param string $sortOrderCode
     * @return \StructType\SearchQualifierType
     */
    public function setSortOrderCode($sortOrderCode = null)
    {
        // validation for constraint: string
        if (!is_null($sortOrderCode) && !is_string($sortOrderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sortOrderCode, true), gettype($sortOrderCode)), __LINE__);
        }
        $this->SortOrderCode = $sortOrderCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchQualifierType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
