<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SailingType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies sailing information.
 * @subpackage Structs
 */
class SailingType extends SailingInfoType
{
    /**
     * The Dining
     * Meta information extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\Dining[]
     */
    public $Dining;
    /**
     * The Transportation
     * Meta information extracted from the WSDL
     * - documentation: Specifies the mode of the transportation from the guest location to the cruise port of departure.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Transportation;
    /**
     * The Information
     * Meta information extracted from the WSDL
     * - documentation: Specifies cruise line registration procedures and other free text information. The name attribute is used to define the type of information. Registration procedures are messages that advise customers who are not registered with the
     * cruise line how to do so. Usually non registered customers cannot get access to the cruise line inventory.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Information;
    /**
     * The MaxCabinOccupancy
     * Meta information extracted from the WSDL
     * - documentation: Maximum cabin occupancy available on this specific sailing (ship).
     * - use: optional
     * @var int
     */
    public $MaxCabinOccupancy;
    /**
     * The CategoryLocation
     * Meta information extracted from the WSDL
     * - documentation: Specifies the different category locations available on the ship.
     * - use: optional
     * @var string
     */
    public $CategoryLocation;
    /**
     * Constructor method for SailingType
     * @uses SailingType::setDining()
     * @uses SailingType::setTransportation()
     * @uses SailingType::setInformation()
     * @uses SailingType::setMaxCabinOccupancy()
     * @uses SailingType::setCategoryLocation()
     * @param \StructType\Dining[] $dining
     * @param mixed[] $transportation
     * @param mixed[] $information
     * @param int $maxCabinOccupancy
     * @param string $categoryLocation
     */
    public function __construct(array $dining = array(), array $transportation = array(), array $information = array(), $maxCabinOccupancy = null, $categoryLocation = null)
    {
        $this
            ->setDining($dining)
            ->setTransportation($transportation)
            ->setInformation($information)
            ->setMaxCabinOccupancy($maxCabinOccupancy)
            ->setCategoryLocation($categoryLocation);
    }
    /**
     * Get Dining value
     * @return \StructType\Dining[]|null
     */
    public function getDining()
    {
        return $this->Dining;
    }
    /**
     * This method is responsible for validating the values passed to the setDining method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDining method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiningForArrayConstraintsFromSetDining(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sailingTypeDiningItem) {
            // validation for constraint: itemType
            if (!$sailingTypeDiningItem instanceof \StructType\Dining) {
                $invalidValues[] = is_object($sailingTypeDiningItem) ? get_class($sailingTypeDiningItem) : sprintf('%s(%s)', gettype($sailingTypeDiningItem), var_export($sailingTypeDiningItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Dining property can only contain items of type \StructType\Dining, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Dining value
     * @throws \InvalidArgumentException
     * @param \StructType\Dining[] $dining
     * @return \StructType\SailingType
     */
    public function setDining(array $dining = array())
    {
        // validation for constraint: array
        if ('' !== ($diningArrayErrorMessage = self::validateDiningForArrayConstraintsFromSetDining($dining))) {
            throw new \InvalidArgumentException($diningArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($dining) && count($dining) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($dining)), __LINE__);
        }
        $this->Dining = $dining;
        return $this;
    }
    /**
     * Add item to Dining value
     * @throws \InvalidArgumentException
     * @param \StructType\Dining $item
     * @return \StructType\SailingType
     */
    public function addToDining(\StructType\Dining $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Dining) {
            throw new \InvalidArgumentException(sprintf('The Dining property can only contain items of type \StructType\Dining, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->Dining) && count($this->Dining) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->Dining)), __LINE__);
        }
        $this->Dining[] = $item;
        return $this;
    }
    /**
     * Get Transportation value
     * @return mixed[]|null
     */
    public function getTransportation()
    {
        return $this->Transportation;
    }
    /**
     * This method is responsible for validating the values passed to the setTransportation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransportation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransportationForArrayConstraintsFromSetTransportation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sailingTypeTransportationItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($sailingTypeTransportationItem) ? get_class($sailingTypeTransportationItem) : sprintf('%s(%s)', gettype($sailingTypeTransportationItem), var_export($sailingTypeTransportationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Transportation property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Transportation value
     * @throws \InvalidArgumentException
     * @param mixed[] $transportation
     * @return \StructType\SailingType
     */
    public function setTransportation(array $transportation = array())
    {
        // validation for constraint: array
        if ('' !== ($transportationArrayErrorMessage = self::validateTransportationForArrayConstraintsFromSetTransportation($transportation))) {
            throw new \InvalidArgumentException($transportationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($transportation) && count($transportation) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($transportation)), __LINE__);
        }
        $this->Transportation = $transportation;
        return $this;
    }
    /**
     * Add item to Transportation value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\SailingType
     */
    public function addToTransportation($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Transportation property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Transportation) && count($this->Transportation) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Transportation)), __LINE__);
        }
        $this->Transportation[] = $item;
        return $this;
    }
    /**
     * Get Information value
     * @return mixed[]|null
     */
    public function getInformation()
    {
        return $this->Information;
    }
    /**
     * This method is responsible for validating the values passed to the setInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInformationForArrayConstraintsFromSetInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sailingTypeInformationItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($sailingTypeInformationItem) ? get_class($sailingTypeInformationItem) : sprintf('%s(%s)', gettype($sailingTypeInformationItem), var_export($sailingTypeInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Information property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Information value
     * @throws \InvalidArgumentException
     * @param mixed[] $information
     * @return \StructType\SailingType
     */
    public function setInformation(array $information = array())
    {
        // validation for constraint: array
        if ('' !== ($informationArrayErrorMessage = self::validateInformationForArrayConstraintsFromSetInformation($information))) {
            throw new \InvalidArgumentException($informationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($information) && count($information) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($information)), __LINE__);
        }
        $this->Information = $information;
        return $this;
    }
    /**
     * Add item to Information value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\SailingType
     */
    public function addToInformation($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Information property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Information) && count($this->Information) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Information)), __LINE__);
        }
        $this->Information[] = $item;
        return $this;
    }
    /**
     * Get MaxCabinOccupancy value
     * @return int|null
     */
    public function getMaxCabinOccupancy()
    {
        return $this->MaxCabinOccupancy;
    }
    /**
     * Set MaxCabinOccupancy value
     * @param int $maxCabinOccupancy
     * @return \StructType\SailingType
     */
    public function setMaxCabinOccupancy($maxCabinOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxCabinOccupancy) && !(is_int($maxCabinOccupancy) || ctype_digit($maxCabinOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxCabinOccupancy, true), gettype($maxCabinOccupancy)), __LINE__);
        }
        $this->MaxCabinOccupancy = $maxCabinOccupancy;
        return $this;
    }
    /**
     * Get CategoryLocation value
     * @return string|null
     */
    public function getCategoryLocation()
    {
        return $this->CategoryLocation;
    }
    /**
     * Set CategoryLocation value
     * @uses \EnumType\CategoryLocationType::valueIsValid()
     * @uses \EnumType\CategoryLocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $categoryLocation
     * @return \StructType\SailingType
     */
    public function setCategoryLocation($categoryLocation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CategoryLocationType::valueIsValid($categoryLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CategoryLocationType', is_array($categoryLocation) ? implode(', ', $categoryLocation) : var_export($categoryLocation, true), implode(', ', \EnumType\CategoryLocationType::getValidValues())), __LINE__);
        }
        $this->CategoryLocation = $categoryLocation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SailingType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
