<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SailingCategoryInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides category information for the specified sailing.
 * @subpackage Structs
 */
class SailingCategoryInfoType extends SailingInfoType
{
    /**
     * The SelectedCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\SelectedCategory[]
     */
    public $SelectedCategory;
    /**
     * Constructor method for SailingCategoryInfoType
     * @uses SailingCategoryInfoType::setSelectedCategory()
     * @param \StructType\SelectedCategory[] $selectedCategory
     */
    public function __construct(array $selectedCategory = array())
    {
        $this
            ->setSelectedCategory($selectedCategory);
    }
    /**
     * Get SelectedCategory value
     * @return \StructType\SelectedCategory[]|null
     */
    public function getSelectedCategory()
    {
        return $this->SelectedCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectedCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectedCategoryForArrayConstraintsFromSetSelectedCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $sailingCategoryInfoTypeSelectedCategoryItem) {
            // validation for constraint: itemType
            if (!$sailingCategoryInfoTypeSelectedCategoryItem instanceof \StructType\SelectedCategory) {
                $invalidValues[] = is_object($sailingCategoryInfoTypeSelectedCategoryItem) ? get_class($sailingCategoryInfoTypeSelectedCategoryItem) : sprintf('%s(%s)', gettype($sailingCategoryInfoTypeSelectedCategoryItem), var_export($sailingCategoryInfoTypeSelectedCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectedCategory property can only contain items of type \StructType\SelectedCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectedCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedCategory[] $selectedCategory
     * @return \StructType\SailingCategoryInfoType
     */
    public function setSelectedCategory(array $selectedCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($selectedCategoryArrayErrorMessage = self::validateSelectedCategoryForArrayConstraintsFromSetSelectedCategory($selectedCategory))) {
            throw new \InvalidArgumentException($selectedCategoryArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($selectedCategory) && count($selectedCategory) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($selectedCategory)), __LINE__);
        }
        $this->SelectedCategory = $selectedCategory;
        return $this;
    }
    /**
     * Add item to SelectedCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedCategory $item
     * @return \StructType\SailingCategoryInfoType
     */
    public function addToSelectedCategory(\StructType\SelectedCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectedCategory) {
            throw new \InvalidArgumentException(sprintf('The SelectedCategory property can only contain items of type \StructType\SelectedCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->SelectedCategory) && count($this->SelectedCategory) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->SelectedCategory)), __LINE__);
        }
        $this->SelectedCategory[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SailingCategoryInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
