<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SailingBaseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines base sailing information.
 * @subpackage Structs
 */
class SailingBaseType extends AbstractStructBase
{
    /**
     * The CruiseLine
     * @var \StructType\CruiseLine
     */
    public $CruiseLine;
    /**
     * The Region
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Region
     */
    public $Region;
    /**
     * The DeparturePort
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DeparturePort
     */
    public $DeparturePort;
    /**
     * The ArrivalPort
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ArrivalPort
     */
    public $ArrivalPort;
    /**
     * The ListOfSailingDescriptionCode
     * Meta information extracted from the WSDL
     * - documentation: Different qualifiers of the sailing (e.g., groups exist on this sailing; inclusive packages available; or no itinerary description available). Refer to OpenTravel Code Table Sailing Description Code (SAI).
     * - use: optional
     * @var list
     */
    public $ListOfSailingDescriptionCode;
    /**
     * Constructor method for SailingBaseType
     * @uses SailingBaseType::setCruiseLine()
     * @uses SailingBaseType::setRegion()
     * @uses SailingBaseType::setDeparturePort()
     * @uses SailingBaseType::setArrivalPort()
     * @uses SailingBaseType::setListOfSailingDescriptionCode()
     * @param \StructType\CruiseLine $cruiseLine
     * @param \StructType\Region $region
     * @param \StructType\DeparturePort $departurePort
     * @param \StructType\ArrivalPort $arrivalPort
     * @param list $listOfSailingDescriptionCode
     */
    public function __construct(\StructType\CruiseLine $cruiseLine = null, \StructType\Region $region = null, \StructType\DeparturePort $departurePort = null, \StructType\ArrivalPort $arrivalPort = null, list $listOfSailingDescriptionCode = null)
    {
        $this
            ->setCruiseLine($cruiseLine)
            ->setRegion($region)
            ->setDeparturePort($departurePort)
            ->setArrivalPort($arrivalPort)
            ->setListOfSailingDescriptionCode($listOfSailingDescriptionCode);
    }
    /**
     * Get CruiseLine value
     * @return \StructType\CruiseLine|null
     */
    public function getCruiseLine()
    {
        return $this->CruiseLine;
    }
    /**
     * Set CruiseLine value
     * @param \StructType\CruiseLine $cruiseLine
     * @return \StructType\SailingBaseType
     */
    public function setCruiseLine(\StructType\CruiseLine $cruiseLine = null)
    {
        $this->CruiseLine = $cruiseLine;
        return $this;
    }
    /**
     * Get Region value
     * @return \StructType\Region|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @param \StructType\Region $region
     * @return \StructType\SailingBaseType
     */
    public function setRegion(\StructType\Region $region = null)
    {
        $this->Region = $region;
        return $this;
    }
    /**
     * Get DeparturePort value
     * @return \StructType\DeparturePort|null
     */
    public function getDeparturePort()
    {
        return $this->DeparturePort;
    }
    /**
     * Set DeparturePort value
     * @param \StructType\DeparturePort $departurePort
     * @return \StructType\SailingBaseType
     */
    public function setDeparturePort(\StructType\DeparturePort $departurePort = null)
    {
        $this->DeparturePort = $departurePort;
        return $this;
    }
    /**
     * Get ArrivalPort value
     * @return \StructType\ArrivalPort|null
     */
    public function getArrivalPort()
    {
        return $this->ArrivalPort;
    }
    /**
     * Set ArrivalPort value
     * @param \StructType\ArrivalPort $arrivalPort
     * @return \StructType\SailingBaseType
     */
    public function setArrivalPort(\StructType\ArrivalPort $arrivalPort = null)
    {
        $this->ArrivalPort = $arrivalPort;
        return $this;
    }
    /**
     * Get ListOfSailingDescriptionCode value
     * @return list|null
     */
    public function getListOfSailingDescriptionCode()
    {
        return $this->ListOfSailingDescriptionCode;
    }
    /**
     * Set ListOfSailingDescriptionCode value
     * @param list $listOfSailingDescriptionCode
     * @return \StructType\SailingBaseType
     */
    public function setListOfSailingDescriptionCode(list $listOfSailingDescriptionCode = null)
    {
        $this->ListOfSailingDescriptionCode = $listOfSailingDescriptionCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SailingBaseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
