<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SSR_Pref StructType
 * Meta information extracted from the WSDL
 * - documentation: Special Service Request preferences. | Indicates Special Service Request preference type.
 * @subpackage Structs
 */
class SSR_Pref extends AbstractStructBase
{
    /**
     * The VendorCode
     * Meta information extracted from the WSDL
     * - documentation: Indicates to which rail operator the element is associated. | Indicates to which airline the element is associated.
     * - use: optional
     * @var string
     */
    public $VendorCode;
    /**
     * The NumberInParty
     * Meta information extracted from the WSDL
     * - documentation: Number of passengers that will benefit from the request.
     * - use: optional
     * @var int
     */
    public $NumberInParty;
    /**
     * The DefaultStatusCode
     * Meta information extracted from the WSDL
     * - documentation: The default status from the rail operators. Refer to the OpenTravel Code List named Status (STS). | The default status from the airline. Refer to the OpenTravel Code List named Status (STS).
     * - use: optional
     * @var string
     */
    public $DefaultStatusCode;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Text that description of the service request.
     * - use: optional
     * @var string
     */
    public $Remark;
    /**
     * The LookupKey
     * Meta information extracted from the WSDL
     * - documentation: Database key to retrieve the other part of the card number.
     * - use: optional
     * @var string
     */
    public $LookupKey;
    /**
     * The AirlineVendorPrefRPH
     * Meta information extracted from the WSDL
     * - documentation: Reference to one or more airlines in VendorPref.
     * - use: optional
     * @var list
     */
    public $AirlineVendorPrefRPH;
    /**
     * The TransferActionType
     * Meta information extracted from the WSDL
     * - documentation: Indicates in what condition the element must be trasnferred to the booking. | Indicates in what condition the element must be transferred to the booking.
     * - use: optional
     * @var string
     */
    public $TransferActionType;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - documentation: Preferred | Used to indicate a level of preference for an associated item.
     * - use: optional
     * @var string
     */
    public $PreferLevel;
    /**
     * The SSR_Code
     * Meta information extracted from the WSDL
     * - documentation: Code of the special service request to be used for this rail travel situation. Refers to standard industry code list. | Code of the special service request to be used for this air travel situation. Refers to standard industry code
     * list.
     * - type: AlphaLength4
     * @var string
     */
    public $SSR_Code;
    /**
     * The VendorPrefRPH
     * Meta information extracted from the WSDL
     * - documentation: Reference to one or more rail operators in VendorPref.
     * - use: optional
     * @var list
     */
    public $VendorPrefRPH;
    /**
     * The ADA_Requirement
     * @var string
     */
    public $ADA_Requirement;
    /**
     * Constructor method for SSR_Pref
     * @uses SSR_Pref::setVendorCode()
     * @uses SSR_Pref::setNumberInParty()
     * @uses SSR_Pref::setDefaultStatusCode()
     * @uses SSR_Pref::setRemark()
     * @uses SSR_Pref::setLookupKey()
     * @uses SSR_Pref::setAirlineVendorPrefRPH()
     * @uses SSR_Pref::setTransferActionType()
     * @uses SSR_Pref::setPreferLevel()
     * @uses SSR_Pref::setSSR_Code()
     * @uses SSR_Pref::setVendorPrefRPH()
     * @uses SSR_Pref::setADA_Requirement()
     * @param string $vendorCode
     * @param int $numberInParty
     * @param string $defaultStatusCode
     * @param string $remark
     * @param string $lookupKey
     * @param list $airlineVendorPrefRPH
     * @param string $transferActionType
     * @param string $preferLevel
     * @param string $sSR_Code
     * @param list $vendorPrefRPH
     * @param string $aDA_Requirement
     */
    public function __construct($vendorCode = null, $numberInParty = null, $defaultStatusCode = null, $remark = null, $lookupKey = null, list $airlineVendorPrefRPH = null, $transferActionType = null, $preferLevel = null, $sSR_Code = null, list $vendorPrefRPH = null, $aDA_Requirement = null)
    {
        $this
            ->setVendorCode($vendorCode)
            ->setNumberInParty($numberInParty)
            ->setDefaultStatusCode($defaultStatusCode)
            ->setRemark($remark)
            ->setLookupKey($lookupKey)
            ->setAirlineVendorPrefRPH($airlineVendorPrefRPH)
            ->setTransferActionType($transferActionType)
            ->setPreferLevel($preferLevel)
            ->setSSR_Code($sSR_Code)
            ->setVendorPrefRPH($vendorPrefRPH)
            ->setADA_Requirement($aDA_Requirement);
    }
    /**
     * Get VendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @param string $vendorCode
     * @return \StructType\SSR_Pref
     */
    public function setVendorCode($vendorCode = null)
    {
        // validation for constraint: string
        if (!is_null($vendorCode) && !is_string($vendorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorCode, true), gettype($vendorCode)), __LINE__);
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get NumberInParty value
     * @return int|null
     */
    public function getNumberInParty()
    {
        return $this->NumberInParty;
    }
    /**
     * Set NumberInParty value
     * @param int $numberInParty
     * @return \StructType\SSR_Pref
     */
    public function setNumberInParty($numberInParty = null)
    {
        // validation for constraint: int
        if (!is_null($numberInParty) && !(is_int($numberInParty) || ctype_digit($numberInParty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberInParty, true), gettype($numberInParty)), __LINE__);
        }
        $this->NumberInParty = $numberInParty;
        return $this;
    }
    /**
     * Get DefaultStatusCode value
     * @return string|null
     */
    public function getDefaultStatusCode()
    {
        return $this->DefaultStatusCode;
    }
    /**
     * Set DefaultStatusCode value
     * @param string $defaultStatusCode
     * @return \StructType\SSR_Pref
     */
    public function setDefaultStatusCode($defaultStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($defaultStatusCode) && !is_string($defaultStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultStatusCode, true), gettype($defaultStatusCode)), __LINE__);
        }
        $this->DefaultStatusCode = $defaultStatusCode;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\SSR_Pref
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get LookupKey value
     * @return string|null
     */
    public function getLookupKey()
    {
        return $this->LookupKey;
    }
    /**
     * Set LookupKey value
     * @param string $lookupKey
     * @return \StructType\SSR_Pref
     */
    public function setLookupKey($lookupKey = null)
    {
        // validation for constraint: string
        if (!is_null($lookupKey) && !is_string($lookupKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lookupKey, true), gettype($lookupKey)), __LINE__);
        }
        $this->LookupKey = $lookupKey;
        return $this;
    }
    /**
     * Get AirlineVendorPrefRPH value
     * @return list|null
     */
    public function getAirlineVendorPrefRPH()
    {
        return $this->AirlineVendorPrefRPH;
    }
    /**
     * Set AirlineVendorPrefRPH value
     * @param list $airlineVendorPrefRPH
     * @return \StructType\SSR_Pref
     */
    public function setAirlineVendorPrefRPH(list $airlineVendorPrefRPH = null)
    {
        $this->AirlineVendorPrefRPH = $airlineVendorPrefRPH;
        return $this;
    }
    /**
     * Get TransferActionType value
     * @return string|null
     */
    public function getTransferActionType()
    {
        return $this->TransferActionType;
    }
    /**
     * Set TransferActionType value
     * @uses \EnumType\TransferActionType::valueIsValid()
     * @uses \EnumType\TransferActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transferActionType
     * @return \StructType\SSR_Pref
     */
    public function setTransferActionType($transferActionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransferActionType::valueIsValid($transferActionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransferActionType', is_array($transferActionType) ? implode(', ', $transferActionType) : var_export($transferActionType, true), implode(', ', \EnumType\TransferActionType::getValidValues())), __LINE__);
        }
        $this->TransferActionType = $transferActionType;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\SSR_Pref
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get SSR_Code value
     * @return string|null
     */
    public function getSSR_Code()
    {
        return $this->SSR_Code;
    }
    /**
     * Set SSR_Code value
     * @param string $sSR_Code
     * @return \StructType\SSR_Pref
     */
    public function setSSR_Code($sSR_Code = null)
    {
        // validation for constraint: string
        if (!is_null($sSR_Code) && !is_string($sSR_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sSR_Code, true), gettype($sSR_Code)), __LINE__);
        }
        $this->SSR_Code = $sSR_Code;
        return $this;
    }
    /**
     * Get VendorPrefRPH value
     * @return list|null
     */
    public function getVendorPrefRPH()
    {
        return $this->VendorPrefRPH;
    }
    /**
     * Set VendorPrefRPH value
     * @param list $vendorPrefRPH
     * @return \StructType\SSR_Pref
     */
    public function setVendorPrefRPH(list $vendorPrefRPH = null)
    {
        $this->VendorPrefRPH = $vendorPrefRPH;
        return $this;
    }
    /**
     * Get ADA_Requirement value
     * @return string|null
     */
    public function getADA_Requirement()
    {
        return $this->ADA_Requirement;
    }
    /**
     * Set ADA_Requirement value
     * @param string $aDA_Requirement
     * @return \StructType\SSR_Pref
     */
    public function setADA_Requirement($aDA_Requirement = null)
    {
        // validation for constraint: string
        if (!is_null($aDA_Requirement) && !is_string($aDA_Requirement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aDA_Requirement, true), gettype($aDA_Requirement)), __LINE__);
        }
        $this->ADA_Requirement = $aDA_Requirement;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SSR_Pref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
