<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleIndicator StructType
 * Meta information extracted from the WSDL
 * - documentation: System generated data indicating the ticket fare is an ATPCO Category number fare.
 * @subpackage Structs
 */
class RuleIndicator extends AbstractStructBase
{
    /**
     * The RuleCode
     * Meta information extracted from the WSDL
     * - documentation: The ATPCO category number for the fare.
     * - use: required
     * @var string
     */
    public $RuleCode;
    /**
     * Constructor method for RuleIndicator
     * @uses RuleIndicator::setRuleCode()
     * @param string $ruleCode
     */
    public function __construct($ruleCode = null)
    {
        $this
            ->setRuleCode($ruleCode);
    }
    /**
     * Get RuleCode value
     * @return string
     */
    public function getRuleCode()
    {
        return $this->RuleCode;
    }
    /**
     * Set RuleCode value
     * @param string $ruleCode
     * @return \StructType\RuleIndicator
     */
    public function setRuleCode($ruleCode = null)
    {
        // validation for constraint: string
        if (!is_null($ruleCode) && !is_string($ruleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleCode, true), gettype($ruleCode)), __LINE__);
        }
        $this->RuleCode = $ruleCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RuleIndicator
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
