<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RowSummaryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Describes summary row information, including number and characteristics.
 * @subpackage Structs
 */
class RowSummaryType extends AbstractStructBase
{
    /**
     * The MaxNumberOfSeats
     * Meta information extracted from the WSDL
     * - documentation: Maximum number of seats per row.
     * @var int
     */
    public $MaxNumberOfSeats;
    /**
     * The RowNumber
     * Meta information extracted from the WSDL
     * - documentation: Specifies the actual (physical) row number in the seat map.
     * - use: optional
     * @var int
     */
    public $RowNumber;
    /**
     * The AirBookDesigCode
     * Meta information extracted from the WSDL
     * - documentation: Allows that a seat may be assigned a class code.
     * - use: optional
     * @var string
     */
    public $AirBookDesigCode;
    /**
     * The RowSequenceNumber
     * Meta information extracted from the WSDL
     * - documentation: The absolute sequence number of real or virtual rows on a plane for describing non-existing intermediate rows, e.g. aisles, galleys or jumpseats.
     * - use: optional
     * @var int
     */
    public $RowSequenceNumber;
    /**
     * The ColumnQty
     * Meta information extracted from the WSDL
     * - documentation: The quantity of coulmns associated with the row.
     * - use: optional
     * @var int
     */
    public $ColumnQty;
    /**
     * Constructor method for RowSummaryType
     * @uses RowSummaryType::setMaxNumberOfSeats()
     * @uses RowSummaryType::setRowNumber()
     * @uses RowSummaryType::setAirBookDesigCode()
     * @uses RowSummaryType::setRowSequenceNumber()
     * @uses RowSummaryType::setColumnQty()
     * @param int $maxNumberOfSeats
     * @param int $rowNumber
     * @param string $airBookDesigCode
     * @param int $rowSequenceNumber
     * @param int $columnQty
     */
    public function __construct($maxNumberOfSeats = null, $rowNumber = null, $airBookDesigCode = null, $rowSequenceNumber = null, $columnQty = null)
    {
        $this
            ->setMaxNumberOfSeats($maxNumberOfSeats)
            ->setRowNumber($rowNumber)
            ->setAirBookDesigCode($airBookDesigCode)
            ->setRowSequenceNumber($rowSequenceNumber)
            ->setColumnQty($columnQty);
    }
    /**
     * Get MaxNumberOfSeats value
     * @return int|null
     */
    public function getMaxNumberOfSeats()
    {
        return $this->MaxNumberOfSeats;
    }
    /**
     * Set MaxNumberOfSeats value
     * @param int $maxNumberOfSeats
     * @return \StructType\RowSummaryType
     */
    public function setMaxNumberOfSeats($maxNumberOfSeats = null)
    {
        // validation for constraint: int
        if (!is_null($maxNumberOfSeats) && !(is_int($maxNumberOfSeats) || ctype_digit($maxNumberOfSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxNumberOfSeats, true), gettype($maxNumberOfSeats)), __LINE__);
        }
        $this->MaxNumberOfSeats = $maxNumberOfSeats;
        return $this;
    }
    /**
     * Get RowNumber value
     * @return int|null
     */
    public function getRowNumber()
    {
        return $this->RowNumber;
    }
    /**
     * Set RowNumber value
     * @param int $rowNumber
     * @return \StructType\RowSummaryType
     */
    public function setRowNumber($rowNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowNumber) && !(is_int($rowNumber) || ctype_digit($rowNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowNumber, true), gettype($rowNumber)), __LINE__);
        }
        $this->RowNumber = $rowNumber;
        return $this;
    }
    /**
     * Get AirBookDesigCode value
     * @return string|null
     */
    public function getAirBookDesigCode()
    {
        return $this->AirBookDesigCode;
    }
    /**
     * Set AirBookDesigCode value
     * @param string $airBookDesigCode
     * @return \StructType\RowSummaryType
     */
    public function setAirBookDesigCode($airBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($airBookDesigCode) && !is_string($airBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airBookDesigCode, true), gettype($airBookDesigCode)), __LINE__);
        }
        $this->AirBookDesigCode = $airBookDesigCode;
        return $this;
    }
    /**
     * Get RowSequenceNumber value
     * @return int|null
     */
    public function getRowSequenceNumber()
    {
        return $this->RowSequenceNumber;
    }
    /**
     * Set RowSequenceNumber value
     * @param int $rowSequenceNumber
     * @return \StructType\RowSummaryType
     */
    public function setRowSequenceNumber($rowSequenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($rowSequenceNumber) && !(is_int($rowSequenceNumber) || ctype_digit($rowSequenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowSequenceNumber, true), gettype($rowSequenceNumber)), __LINE__);
        }
        $this->RowSequenceNumber = $rowSequenceNumber;
        return $this;
    }
    /**
     * Get ColumnQty value
     * @return int|null
     */
    public function getColumnQty()
    {
        return $this->ColumnQty;
    }
    /**
     * Set ColumnQty value
     * @param int $columnQty
     * @return \StructType\RowSummaryType
     */
    public function setColumnQty($columnQty = null)
    {
        // validation for constraint: int
        if (!is_null($columnQty) && !(is_int($columnQty) || ctype_digit($columnQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($columnQty, true), gettype($columnQty)), __LINE__);
        }
        $this->ColumnQty = $columnQty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RowSummaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
