<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomTypeLiteType StructType
 * Meta information extracted from the WSDL
 * - documentation: Summary version of the RoomTypeType, initially created for the Travel Itinerary Message set.
 * @subpackage Structs
 */
class RoomTypeLiteType extends AbstractStructBase
{
    /**
     * The RoomDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $RoomDescription;
    /**
     * The Amenity
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Amenity;
    /**
     * The RoomTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specfic system room type code, ex: A1K, A1Q etc.
     * - use: optional
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The NumberOfUnits
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $NumberOfUnits;
    /**
     * Constructor method for RoomTypeLiteType
     * @uses RoomTypeLiteType::setRoomDescription()
     * @uses RoomTypeLiteType::setAmenity()
     * @uses RoomTypeLiteType::setRoomTypeCode()
     * @uses RoomTypeLiteType::setNumberOfUnits()
     * @param mixed $roomDescription
     * @param mixed[] $amenity
     * @param string $roomTypeCode
     * @param int $numberOfUnits
     */
    public function __construct($roomDescription = null, array $amenity = array(), $roomTypeCode = null, $numberOfUnits = null)
    {
        $this
            ->setRoomDescription($roomDescription)
            ->setAmenity($amenity)
            ->setRoomTypeCode($roomTypeCode)
            ->setNumberOfUnits($numberOfUnits);
    }
    /**
     * Get RoomDescription value
     * @return mixed|null
     */
    public function getRoomDescription()
    {
        return $this->RoomDescription;
    }
    /**
     * Set RoomDescription value
     * @param mixed $roomDescription
     * @return \StructType\RoomTypeLiteType
     */
    public function setRoomDescription($roomDescription = null)
    {
        $this->RoomDescription = $roomDescription;
        return $this;
    }
    /**
     * Get Amenity value
     * @return mixed[]|null
     */
    public function getAmenity()
    {
        return $this->Amenity;
    }
    /**
     * This method is responsible for validating the values passed to the setAmenity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmenity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAmenityForArrayConstraintsFromSetAmenity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomTypeLiteTypeAmenityItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($roomTypeLiteTypeAmenityItem) ? get_class($roomTypeLiteTypeAmenityItem) : sprintf('%s(%s)', gettype($roomTypeLiteTypeAmenityItem), var_export($roomTypeLiteTypeAmenityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Amenity property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Amenity value
     * @throws \InvalidArgumentException
     * @param mixed[] $amenity
     * @return \StructType\RoomTypeLiteType
     */
    public function setAmenity(array $amenity = array())
    {
        // validation for constraint: array
        if ('' !== ($amenityArrayErrorMessage = self::validateAmenityForArrayConstraintsFromSetAmenity($amenity))) {
            throw new \InvalidArgumentException($amenityArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($amenity) && count($amenity) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($amenity)), __LINE__);
        }
        $this->Amenity = $amenity;
        return $this;
    }
    /**
     * Add item to Amenity value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RoomTypeLiteType
     */
    public function addToAmenity($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Amenity property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Amenity) && count($this->Amenity) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Amenity)), __LINE__);
        }
        $this->Amenity[] = $item;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\RoomTypeLiteType
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \StructType\RoomTypeLiteType
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !(is_int($numberOfUnits) || ctype_digit($numberOfUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfUnits, true), gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomTypeLiteType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
