<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomTypeAllocByGuest StructType
 * Meta information extracted from the WSDL
 * - documentation: This is the number of rooms blocked for a specific room type for specific dates by a given number of guests.
 * @subpackage Structs
 */
class RoomTypeAllocByGuest extends AbstractStructBase
{
    /**
     * The NumberOfGuests
     * Meta information extracted from the WSDL
     * - documentation: The number of guests associated with this room type allocation.
     * - use: required
     * @var int
     */
    public $NumberOfGuests;
    /**
     * The NumberOfUnits
     * Meta information extracted from the WSDL
     * - documentation: The number of rooms allocated for the dates specified in the DateTimeSpanGroup. This is the number of units allocated for this particular number of guests for this room type.
     * - use: required
     * @var int
     */
    public $NumberOfUnits;
    /**
     * Constructor method for RoomTypeAllocByGuest
     * @uses RoomTypeAllocByGuest::setNumberOfGuests()
     * @uses RoomTypeAllocByGuest::setNumberOfUnits()
     * @param int $numberOfGuests
     * @param int $numberOfUnits
     */
    public function __construct($numberOfGuests = null, $numberOfUnits = null)
    {
        $this
            ->setNumberOfGuests($numberOfGuests)
            ->setNumberOfUnits($numberOfUnits);
    }
    /**
     * Get NumberOfGuests value
     * @return int
     */
    public function getNumberOfGuests()
    {
        return $this->NumberOfGuests;
    }
    /**
     * Set NumberOfGuests value
     * @param int $numberOfGuests
     * @return \StructType\RoomTypeAllocByGuest
     */
    public function setNumberOfGuests($numberOfGuests = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfGuests) && !(is_int($numberOfGuests) || ctype_digit($numberOfGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfGuests, true), gettype($numberOfGuests)), __LINE__);
        }
        $this->NumberOfGuests = $numberOfGuests;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \StructType\RoomTypeAllocByGuest
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !(is_int($numberOfUnits) || ctype_digit($numberOfUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfUnits, true), gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomTypeAllocByGuest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
