<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomRateType StructType
 * Meta information extracted from the WSDL
 * - documentation: Individual rate amount. This rate is valid for a range of number of occupants and an occupant type.
 * @subpackage Structs
 */
class RoomRateType extends AbstractStructBase
{
    /**
     * The Rates
     * Meta information extracted from the WSDL
     * - documentation: Individual rate amount. This rate is valid for a range of number of occupants and an occupant type.
     * - minOccurs: 0
     * @var mixed
     */
    public $Rates;
    /**
     * The RoomRateDescription
     * Meta information extracted from the WSDL
     * - documentation: The description or name of a room rate.
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var mixed[]
     */
    public $RoomRateDescription;
    /**
     * The Features
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Features
     */
    public $Features;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - documentation: The total of all rates for this room rate type.
     * - minOccurs: 0
     * @var mixed
     */
    public $Total;
    /**
     * The Availability
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\Availability[]
     */
    public $Availability;
    /**
     * The BookingCode
     * Meta information extracted from the WSDL
     * - documentation: This is used to indicate the item booked and is primarily used to exchange information with GDSs.
     * - use: optional
     * @var string
     */
    public $BookingCode;
    /**
     * The RoomTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Specfic system room type code, ex: A1K, A1Q etc.
     * - use: optional
     * @var string
     */
    public $RoomTypeCode;
    /**
     * The InvBlockCode
     * Meta information extracted from the WSDL
     * - documentation: Code that identifies an inventory block.
     * - use: optional
     * @var string
     */
    public $InvBlockCode;
    /**
     * The NumberOfUnits
     * Meta information extracted from the WSDL
     * - documentation: The number of rooms.
     * - use: optional
     * @var int
     */
    public $NumberOfUnits;
    /**
     * The AvailabilityStatus
     * Meta information extracted from the WSDL
     * - documentation: Used to specify an availability status for the room rate.
     * - use: optional
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * The RoomID
     * Meta information extracted from the WSDL
     * - documentation: A string value representing the unique identification of a room.
     * - use: optional
     * @var string
     */
    public $RoomID;
    /**
     * Constructor method for RoomRateType
     * @uses RoomRateType::setRates()
     * @uses RoomRateType::setRoomRateDescription()
     * @uses RoomRateType::setFeatures()
     * @uses RoomRateType::setTotal()
     * @uses RoomRateType::setAvailability()
     * @uses RoomRateType::setBookingCode()
     * @uses RoomRateType::setRoomTypeCode()
     * @uses RoomRateType::setInvBlockCode()
     * @uses RoomRateType::setNumberOfUnits()
     * @uses RoomRateType::setAvailabilityStatus()
     * @uses RoomRateType::setRoomID()
     * @param mixed $rates
     * @param mixed[] $roomRateDescription
     * @param \StructType\Features $features
     * @param mixed $total
     * @param \StructType\Availability[] $availability
     * @param string $bookingCode
     * @param string $roomTypeCode
     * @param string $invBlockCode
     * @param int $numberOfUnits
     * @param string $availabilityStatus
     * @param string $roomID
     */
    public function __construct($rates = null, array $roomRateDescription = array(), \StructType\Features $features = null, $total = null, array $availability = array(), $bookingCode = null, $roomTypeCode = null, $invBlockCode = null, $numberOfUnits = null, $availabilityStatus = null, $roomID = null)
    {
        $this
            ->setRates($rates)
            ->setRoomRateDescription($roomRateDescription)
            ->setFeatures($features)
            ->setTotal($total)
            ->setAvailability($availability)
            ->setBookingCode($bookingCode)
            ->setRoomTypeCode($roomTypeCode)
            ->setInvBlockCode($invBlockCode)
            ->setNumberOfUnits($numberOfUnits)
            ->setAvailabilityStatus($availabilityStatus)
            ->setRoomID($roomID);
    }
    /**
     * Get Rates value
     * @return mixed|null
     */
    public function getRates()
    {
        return $this->Rates;
    }
    /**
     * Set Rates value
     * @param mixed $rates
     * @return \StructType\RoomRateType
     */
    public function setRates($rates = null)
    {
        $this->Rates = $rates;
        return $this;
    }
    /**
     * Get RoomRateDescription value
     * @return mixed[]|null
     */
    public function getRoomRateDescription()
    {
        return $this->RoomRateDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomRateDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomRateDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomRateDescriptionForArrayConstraintsFromSetRoomRateDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomRateTypeRoomRateDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($roomRateTypeRoomRateDescriptionItem) ? get_class($roomRateTypeRoomRateDescriptionItem) : sprintf('%s(%s)', gettype($roomRateTypeRoomRateDescriptionItem), var_export($roomRateTypeRoomRateDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomRateDescription property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomRateDescription value
     * @throws \InvalidArgumentException
     * @param mixed[] $roomRateDescription
     * @return \StructType\RoomRateType
     */
    public function setRoomRateDescription(array $roomRateDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($roomRateDescriptionArrayErrorMessage = self::validateRoomRateDescriptionForArrayConstraintsFromSetRoomRateDescription($roomRateDescription))) {
            throw new \InvalidArgumentException($roomRateDescriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($roomRateDescription) && count($roomRateDescription) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($roomRateDescription)), __LINE__);
        }
        $this->RoomRateDescription = $roomRateDescription;
        return $this;
    }
    /**
     * Add item to RoomRateDescription value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RoomRateType
     */
    public function addToRoomRateDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RoomRateDescription property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->RoomRateDescription) && count($this->RoomRateDescription) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->RoomRateDescription)), __LINE__);
        }
        $this->RoomRateDescription[] = $item;
        return $this;
    }
    /**
     * Get Features value
     * @return \StructType\Features|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * Set Features value
     * @param \StructType\Features $features
     * @return \StructType\RoomRateType
     */
    public function setFeatures(\StructType\Features $features = null)
    {
        $this->Features = $features;
        return $this;
    }
    /**
     * Get Total value
     * @return mixed|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param mixed $total
     * @return \StructType\RoomRateType
     */
    public function setTotal($total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Availability value
     * @return \StructType\Availability[]|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * This method is responsible for validating the values passed to the setAvailability method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAvailability method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAvailabilityForArrayConstraintsFromSetAvailability(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomRateTypeAvailabilityItem) {
            // validation for constraint: itemType
            if (!$roomRateTypeAvailabilityItem instanceof \StructType\Availability) {
                $invalidValues[] = is_object($roomRateTypeAvailabilityItem) ? get_class($roomRateTypeAvailabilityItem) : sprintf('%s(%s)', gettype($roomRateTypeAvailabilityItem), var_export($roomRateTypeAvailabilityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Availability property can only contain items of type \StructType\Availability, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Availability value
     * @throws \InvalidArgumentException
     * @param \StructType\Availability[] $availability
     * @return \StructType\RoomRateType
     */
    public function setAvailability(array $availability = array())
    {
        // validation for constraint: array
        if ('' !== ($availabilityArrayErrorMessage = self::validateAvailabilityForArrayConstraintsFromSetAvailability($availability))) {
            throw new \InvalidArgumentException($availabilityArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($availability) && count($availability) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($availability)), __LINE__);
        }
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Add item to Availability value
     * @throws \InvalidArgumentException
     * @param \StructType\Availability $item
     * @return \StructType\RoomRateType
     */
    public function addToAvailability(\StructType\Availability $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Availability) {
            throw new \InvalidArgumentException(sprintf('The Availability property can only contain items of type \StructType\Availability, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Availability) && count($this->Availability) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Availability)), __LINE__);
        }
        $this->Availability[] = $item;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return string|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param string $bookingCode
     * @return \StructType\RoomRateType
     */
    public function setBookingCode($bookingCode = null)
    {
        // validation for constraint: string
        if (!is_null($bookingCode) && !is_string($bookingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingCode, true), gettype($bookingCode)), __LINE__);
        }
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get RoomTypeCode value
     * @return string|null
     */
    public function getRoomTypeCode()
    {
        return $this->RoomTypeCode;
    }
    /**
     * Set RoomTypeCode value
     * @param string $roomTypeCode
     * @return \StructType\RoomRateType
     */
    public function setRoomTypeCode($roomTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($roomTypeCode) && !is_string($roomTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomTypeCode, true), gettype($roomTypeCode)), __LINE__);
        }
        $this->RoomTypeCode = $roomTypeCode;
        return $this;
    }
    /**
     * Get InvBlockCode value
     * @return string|null
     */
    public function getInvBlockCode()
    {
        return $this->InvBlockCode;
    }
    /**
     * Set InvBlockCode value
     * @param string $invBlockCode
     * @return \StructType\RoomRateType
     */
    public function setInvBlockCode($invBlockCode = null)
    {
        // validation for constraint: string
        if (!is_null($invBlockCode) && !is_string($invBlockCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invBlockCode, true), gettype($invBlockCode)), __LINE__);
        }
        $this->InvBlockCode = $invBlockCode;
        return $this;
    }
    /**
     * Get NumberOfUnits value
     * @return int|null
     */
    public function getNumberOfUnits()
    {
        return $this->NumberOfUnits;
    }
    /**
     * Set NumberOfUnits value
     * @param int $numberOfUnits
     * @return \StructType\RoomRateType
     */
    public function setNumberOfUnits($numberOfUnits = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfUnits) && !(is_int($numberOfUnits) || ctype_digit($numberOfUnits))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfUnits, true), gettype($numberOfUnits)), __LINE__);
        }
        $this->NumberOfUnits = $numberOfUnits;
        return $this;
    }
    /**
     * Get AvailabilityStatus value
     * @return string|null
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @uses \EnumType\RateIndicatorType::valueIsValid()
     * @uses \EnumType\RateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityStatus
     * @return \StructType\RoomRateType
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RateIndicatorType::valueIsValid($availabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RateIndicatorType', is_array($availabilityStatus) ? implode(', ', $availabilityStatus) : var_export($availabilityStatus, true), implode(', ', \EnumType\RateIndicatorType::getValidValues())), __LINE__);
        }
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
    /**
     * Get RoomID value
     * @return string|null
     */
    public function getRoomID()
    {
        return $this->RoomID;
    }
    /**
     * Set RoomID value
     * @param string $roomID
     * @return \StructType\RoomRateType
     */
    public function setRoomID($roomID = null)
    {
        // validation for constraint: string
        if (!is_null($roomID) && !is_string($roomID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomID, true), gettype($roomID)), __LINE__);
        }
        $this->RoomID = $roomID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomRateType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
