<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomProfile StructType
 * Meta information extracted from the WSDL
 * - documentation: Describes the occupancy of a room or cabin.
 * @subpackage Structs
 */
class RoomProfile extends RoomProfileType
{
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\Prices[]
     */
    public $Prices;
    /**
     * Constructor method for RoomProfile
     * @uses RoomProfile::setPrices()
     * @param \StructType\Prices[] $prices
     */
    public function __construct(array $prices = array())
    {
        $this
            ->setPrices($prices);
    }
    /**
     * Get Prices value
     * @return \StructType\Prices[]|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * This method is responsible for validating the values passed to the setPrices method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrices method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricesForArrayConstraintsFromSetPrices(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomProfilePricesItem) {
            // validation for constraint: itemType
            if (!$roomProfilePricesItem instanceof \StructType\Prices) {
                $invalidValues[] = is_object($roomProfilePricesItem) ? get_class($roomProfilePricesItem) : sprintf('%s(%s)', gettype($roomProfilePricesItem), var_export($roomProfilePricesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Prices property can only contain items of type \StructType\Prices, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Prices value
     * @throws \InvalidArgumentException
     * @param \StructType\Prices[] $prices
     * @return \StructType\RoomProfile
     */
    public function setPrices(array $prices = array())
    {
        // validation for constraint: array
        if ('' !== ($pricesArrayErrorMessage = self::validatePricesForArrayConstraintsFromSetPrices($prices))) {
            throw new \InvalidArgumentException($pricesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($prices) && count($prices) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($prices)), __LINE__);
        }
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Add item to Prices value
     * @throws \InvalidArgumentException
     * @param \StructType\Prices $item
     * @return \StructType\RoomProfile
     */
    public function addToPrices(\StructType\Prices $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Prices) {
            throw new \InvalidArgumentException(sprintf('The Prices property can only contain items of type \StructType\Prices, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->Prices) && count($this->Prices) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->Prices)), __LINE__);
        }
        $this->Prices[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
