<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomPrices StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of price information for each available room based on an available board terms (meal plan) e.g prices for each room based on Half Board.
 * @subpackage Structs
 */
class RoomPrices extends AbstractStructBase
{
    /**
     * The RoomPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var mixed[]
     */
    public $RoomPrice;
    /**
     * The MealPlan
     * Meta information extracted from the WSDL
     * - documentation: The code for a meal plan e.g. AB- as brochure, AI- all inclusive, BB- bed and breakfast, FB- full board, HB- Half Board, RO- room only,SC- self catering
     * @var string
     */
    public $MealPlan;
    /**
     * Constructor method for RoomPrices
     * @uses RoomPrices::setRoomPrice()
     * @uses RoomPrices::setMealPlan()
     * @param mixed[] $roomPrice
     * @param string $mealPlan
     */
    public function __construct(array $roomPrice = array(), $mealPlan = null)
    {
        $this
            ->setRoomPrice($roomPrice)
            ->setMealPlan($mealPlan);
    }
    /**
     * Get RoomPrice value
     * @return mixed[]|null
     */
    public function getRoomPrice()
    {
        return $this->RoomPrice;
    }
    /**
     * This method is responsible for validating the values passed to the setRoomPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoomPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomPriceForArrayConstraintsFromSetRoomPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomPricesRoomPriceItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($roomPricesRoomPriceItem) ? get_class($roomPricesRoomPriceItem) : sprintf('%s(%s)', gettype($roomPricesRoomPriceItem), var_export($roomPricesRoomPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoomPrice property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoomPrice value
     * @throws \InvalidArgumentException
     * @param mixed[] $roomPrice
     * @return \StructType\RoomPrices
     */
    public function setRoomPrice(array $roomPrice = array())
    {
        // validation for constraint: array
        if ('' !== ($roomPriceArrayErrorMessage = self::validateRoomPriceForArrayConstraintsFromSetRoomPrice($roomPrice))) {
            throw new \InvalidArgumentException($roomPriceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($roomPrice) && count($roomPrice) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($roomPrice)), __LINE__);
        }
        $this->RoomPrice = $roomPrice;
        return $this;
    }
    /**
     * Add item to RoomPrice value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RoomPrices
     */
    public function addToRoomPrice($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RoomPrice property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->RoomPrice) && count($this->RoomPrice) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->RoomPrice)), __LINE__);
        }
        $this->RoomPrice[] = $item;
        return $this;
    }
    /**
     * Get MealPlan value
     * @return string|null
     */
    public function getMealPlan()
    {
        return $this->MealPlan;
    }
    /**
     * Set MealPlan value
     * @param string $mealPlan
     * @return \StructType\RoomPrices
     */
    public function setMealPlan($mealPlan = null)
    {
        // validation for constraint: string
        if (!is_null($mealPlan) && !is_string($mealPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mealPlan, true), gettype($mealPlan)), __LINE__);
        }
        $this->MealPlan = $mealPlan;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomPrices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
