<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomCompanions StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the ages of the guests that may stay in the room. | Defines the required type and number of companions in the room in order for this supplement to apply (e.g., one adult required for a child supplement to apply).
 * @subpackage Structs
 */
class RoomCompanions extends AbstractStructBase
{
    /**
     * The MinCompanions
     * Meta information extracted from the WSDL
     * - documentation: The minimum number of guests of the specified age group required in the room in order to apply this supplement.
     * - use: optional
     * @var int
     */
    public $MinCompanions;
    /**
     * The MaxCompanions
     * Meta information extracted from the WSDL
     * - documentation: The maximum number of guests of the specified age group permitted in the room in order to apply this supplement.
     * - use: optional
     * @var int
     */
    public $MaxCompanions;
    /**
     * Constructor method for RoomCompanions
     * @uses RoomCompanions::setMinCompanions()
     * @uses RoomCompanions::setMaxCompanions()
     * @param int $minCompanions
     * @param int $maxCompanions
     */
    public function __construct($minCompanions = null, $maxCompanions = null)
    {
        $this
            ->setMinCompanions($minCompanions)
            ->setMaxCompanions($maxCompanions);
    }
    /**
     * Get MinCompanions value
     * @return int|null
     */
    public function getMinCompanions()
    {
        return $this->MinCompanions;
    }
    /**
     * Set MinCompanions value
     * @param int $minCompanions
     * @return \StructType\RoomCompanions
     */
    public function setMinCompanions($minCompanions = null)
    {
        // validation for constraint: int
        if (!is_null($minCompanions) && !(is_int($minCompanions) || ctype_digit($minCompanions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minCompanions, true), gettype($minCompanions)), __LINE__);
        }
        $this->MinCompanions = $minCompanions;
        return $this;
    }
    /**
     * Get MaxCompanions value
     * @return int|null
     */
    public function getMaxCompanions()
    {
        return $this->MaxCompanions;
    }
    /**
     * Set MaxCompanions value
     * @param int $maxCompanions
     * @return \StructType\RoomCompanions
     */
    public function setMaxCompanions($maxCompanions = null)
    {
        // validation for constraint: int
        if (!is_null($maxCompanions) && !(is_int($maxCompanions) || ctype_digit($maxCompanions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxCompanions, true), gettype($maxCompanions)), __LINE__);
        }
        $this->MaxCompanions = $maxCompanions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomCompanions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
