<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomBlocks StructType
 * Meta information extracted from the WSDL
 * - documentation: Describes room block information accepted by the hotel.
 * @subpackage Structs
 */
class RoomBlocks extends AbstractStructBase
{
    /**
     * The AvailableInd
     * Meta information extracted from the WSDL
     * - documentation: If TRUE, room blocks are accepted.
     * - use: optional
     * @var bool
     */
    public $AvailableInd;
    /**
     * The TotalRoomQty
     * Meta information extracted from the WSDL
     * - documentation: The total quantity of rooms that are available for room blocks.
     * - use: optional
     * @var int
     */
    public $TotalRoomQty;
    /**
     * The CancelPeriodDays
     * Meta information extracted from the WSDL
     * - documentation: The number of days advance notice to cancel a room block.
     * - use: optional
     * @var int
     */
    public $CancelPeriodDays;
    /**
     * The RateType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RateType;
    /**
     * The RoomType
     * Meta information extracted from the WSDL
     * - documentation: Room type(s) that are available for room blocks. Please use a value from the OpenTravel Guest Room Information (GRI) Code List.
     * - use: optional
     * @var string
     */
    public $RoomType;
    /**
     * The BlackOutDate
     * Meta information extracted from the WSDL
     * - documentation: Date(s) the room block is not available.
     * - use: optional
     * @var string
     */
    public $BlackOutDate;
    /**
     * Constructor method for RoomBlocks
     * @uses RoomBlocks::setAvailableInd()
     * @uses RoomBlocks::setTotalRoomQty()
     * @uses RoomBlocks::setCancelPeriodDays()
     * @uses RoomBlocks::setRateType()
     * @uses RoomBlocks::setRoomType()
     * @uses RoomBlocks::setBlackOutDate()
     * @param bool $availableInd
     * @param int $totalRoomQty
     * @param int $cancelPeriodDays
     * @param string $rateType
     * @param string $roomType
     * @param string $blackOutDate
     */
    public function __construct($availableInd = null, $totalRoomQty = null, $cancelPeriodDays = null, $rateType = null, $roomType = null, $blackOutDate = null)
    {
        $this
            ->setAvailableInd($availableInd)
            ->setTotalRoomQty($totalRoomQty)
            ->setCancelPeriodDays($cancelPeriodDays)
            ->setRateType($rateType)
            ->setRoomType($roomType)
            ->setBlackOutDate($blackOutDate);
    }
    /**
     * Get AvailableInd value
     * @return bool|null
     */
    public function getAvailableInd()
    {
        return $this->AvailableInd;
    }
    /**
     * Set AvailableInd value
     * @param bool $availableInd
     * @return \StructType\RoomBlocks
     */
    public function setAvailableInd($availableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableInd) && !is_bool($availableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableInd, true), gettype($availableInd)), __LINE__);
        }
        $this->AvailableInd = $availableInd;
        return $this;
    }
    /**
     * Get TotalRoomQty value
     * @return int|null
     */
    public function getTotalRoomQty()
    {
        return $this->TotalRoomQty;
    }
    /**
     * Set TotalRoomQty value
     * @param int $totalRoomQty
     * @return \StructType\RoomBlocks
     */
    public function setTotalRoomQty($totalRoomQty = null)
    {
        // validation for constraint: int
        if (!is_null($totalRoomQty) && !(is_int($totalRoomQty) || ctype_digit($totalRoomQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalRoomQty, true), gettype($totalRoomQty)), __LINE__);
        }
        $this->TotalRoomQty = $totalRoomQty;
        return $this;
    }
    /**
     * Get CancelPeriodDays value
     * @return int|null
     */
    public function getCancelPeriodDays()
    {
        return $this->CancelPeriodDays;
    }
    /**
     * Set CancelPeriodDays value
     * @param int $cancelPeriodDays
     * @return \StructType\RoomBlocks
     */
    public function setCancelPeriodDays($cancelPeriodDays = null)
    {
        // validation for constraint: int
        if (!is_null($cancelPeriodDays) && !(is_int($cancelPeriodDays) || ctype_digit($cancelPeriodDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cancelPeriodDays, true), gettype($cancelPeriodDays)), __LINE__);
        }
        $this->CancelPeriodDays = $cancelPeriodDays;
        return $this;
    }
    /**
     * Get RateType value
     * @return string|null
     */
    public function getRateType()
    {
        return $this->RateType;
    }
    /**
     * Set RateType value
     * @param string $rateType
     * @return \StructType\RoomBlocks
     */
    public function setRateType($rateType = null)
    {
        // validation for constraint: string
        if (!is_null($rateType) && !is_string($rateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateType, true), gettype($rateType)), __LINE__);
        }
        $this->RateType = $rateType;
        return $this;
    }
    /**
     * Get RoomType value
     * @return string|null
     */
    public function getRoomType()
    {
        return $this->RoomType;
    }
    /**
     * Set RoomType value
     * @param string $roomType
     * @return \StructType\RoomBlocks
     */
    public function setRoomType($roomType = null)
    {
        // validation for constraint: string
        if (!is_null($roomType) && !is_string($roomType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomType, true), gettype($roomType)), __LINE__);
        }
        $this->RoomType = $roomType;
        return $this;
    }
    /**
     * Get BlackOutDate value
     * @return string|null
     */
    public function getBlackOutDate()
    {
        return $this->BlackOutDate;
    }
    /**
     * Set BlackOutDate value
     * @param string $blackOutDate
     * @return \StructType\RoomBlocks
     */
    public function setBlackOutDate($blackOutDate = null)
    {
        // validation for constraint: string
        if (!is_null($blackOutDate) && !is_string($blackOutDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blackOutDate, true), gettype($blackOutDate)), __LINE__);
        }
        $this->BlackOutDate = $blackOutDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RoomBlocks
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
