<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RevenueCategoriesType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of RevenueCategory classes that detail the categories of revenue data associated with the StayInfo report.
 * @subpackage Structs
 */
class RevenueCategoriesType extends AbstractStructBase
{
    /**
     * The RevenueCategory
     * Meta information extracted from the WSDL
     * - documentation: The classifications of revenue data associated with the StayInfo report. A RevenueCategory provide a way to classify guest financial stay data and analyze guest spending for a certain category (e.g., food and beverage, room, etc.)
     * - maxOccurs: 99
     * @var mixed[]
     */
    public $RevenueCategory;
    /**
     * Constructor method for RevenueCategoriesType
     * @uses RevenueCategoriesType::setRevenueCategory()
     * @param mixed[] $revenueCategory
     */
    public function __construct(array $revenueCategory = array())
    {
        $this
            ->setRevenueCategory($revenueCategory);
    }
    /**
     * Get RevenueCategory value
     * @return mixed[]|null
     */
    public function getRevenueCategory()
    {
        return $this->RevenueCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setRevenueCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRevenueCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRevenueCategoryForArrayConstraintsFromSetRevenueCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $revenueCategoriesTypeRevenueCategoryItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($revenueCategoriesTypeRevenueCategoryItem) ? get_class($revenueCategoriesTypeRevenueCategoryItem) : sprintf('%s(%s)', gettype($revenueCategoriesTypeRevenueCategoryItem), var_export($revenueCategoriesTypeRevenueCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RevenueCategory property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RevenueCategory value
     * @throws \InvalidArgumentException
     * @param mixed[] $revenueCategory
     * @return \StructType\RevenueCategoriesType
     */
    public function setRevenueCategory(array $revenueCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($revenueCategoryArrayErrorMessage = self::validateRevenueCategoryForArrayConstraintsFromSetRevenueCategory($revenueCategory))) {
            throw new \InvalidArgumentException($revenueCategoryArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($revenueCategory) && count($revenueCategory) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($revenueCategory)), __LINE__);
        }
        $this->RevenueCategory = $revenueCategory;
        return $this;
    }
    /**
     * Add item to RevenueCategory value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RevenueCategoriesType
     */
    public function addToRevenueCategory($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RevenueCategory property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->RevenueCategory) && count($this->RevenueCategory) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->RevenueCategory)), __LINE__);
        }
        $this->RevenueCategory[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RevenueCategoriesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
