<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Restriction StructType
 * Meta information extracted from the WSDL
 * - documentation: Restrictions that apply to the priced offer, such as “Seat requests available up to 24 hours before departure". | The effective date range for which the restriction applies. | Information on the restriction associated with the
 * RoomRate element.
 * - use: optional
 * @subpackage Structs
 */
class Restriction extends AbstractStructBase
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Other restrictions that apply to the priced offer, such as “Seat requests available up to 24 hours before departure".
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The TripMinOfferQty
     * Meta information extracted from the WSDL
     * - documentation: The minumum quantity of this offer that must be purchased for the trip as a whole.
     * - use: optional
     * @var int
     */
    public $TripMinOfferQty;
    /**
     * The TripMaxOfferQty
     * Meta information extracted from the WSDL
     * - documentation: The maximum quantity of this offer that may be purchased for the trip as a whole.
     * - use: optional
     * @var int
     */
    public $TripMaxOfferQty;
    /**
     * The TravelerMinOfferQty
     * Meta information extracted from the WSDL
     * - documentation: The minumum quantity of this offer that must be purchased by one traveler.
     * - use: optional
     * @var int
     */
    public $TravelerMinOfferQty;
    /**
     * The TravelerMaxOfferQty
     * Meta information extracted from the WSDL
     * - documentation: The maximum quantity of this offer that may be purchased by one traveler.
     * - use: optional
     * @var int
     */
    public $TravelerMaxOfferQty;
    /**
     * The EffectiveDate
     * Meta information extracted from the WSDL
     * - documentation: The date that an offer is available/ usable.
     * - use: optional
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - documentation: The date that an offer is no longer available/ usable.
     * - use: optional
     * @var string
     */
    public $ExpireDate;
    /**
     * The DOW_Restrictions
     * Meta information extracted from the WSDL
     * - documentation: A collection of day of week restrictions.
     * @var mixed
     */
    public $DOW_Restrictions;
    /**
     * Constructor method for Restriction
     * @uses Restriction::setDescription()
     * @uses Restriction::setTripMinOfferQty()
     * @uses Restriction::setTripMaxOfferQty()
     * @uses Restriction::setTravelerMinOfferQty()
     * @uses Restriction::setTravelerMaxOfferQty()
     * @uses Restriction::setEffectiveDate()
     * @uses Restriction::setExpireDate()
     * @uses Restriction::setDOW_Restrictions()
     * @param string $description
     * @param int $tripMinOfferQty
     * @param int $tripMaxOfferQty
     * @param int $travelerMinOfferQty
     * @param int $travelerMaxOfferQty
     * @param string $effectiveDate
     * @param string $expireDate
     * @param mixed $dOW_Restrictions
     */
    public function __construct($description = null, $tripMinOfferQty = null, $tripMaxOfferQty = null, $travelerMinOfferQty = null, $travelerMaxOfferQty = null, $effectiveDate = null, $expireDate = null, $dOW_Restrictions = null)
    {
        $this
            ->setDescription($description)
            ->setTripMinOfferQty($tripMinOfferQty)
            ->setTripMaxOfferQty($tripMaxOfferQty)
            ->setTravelerMinOfferQty($travelerMinOfferQty)
            ->setTravelerMaxOfferQty($travelerMaxOfferQty)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate)
            ->setDOW_Restrictions($dOW_Restrictions);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Restriction
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get TripMinOfferQty value
     * @return int|null
     */
    public function getTripMinOfferQty()
    {
        return $this->TripMinOfferQty;
    }
    /**
     * Set TripMinOfferQty value
     * @param int $tripMinOfferQty
     * @return \StructType\Restriction
     */
    public function setTripMinOfferQty($tripMinOfferQty = null)
    {
        // validation for constraint: int
        if (!is_null($tripMinOfferQty) && !(is_int($tripMinOfferQty) || ctype_digit($tripMinOfferQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tripMinOfferQty, true), gettype($tripMinOfferQty)), __LINE__);
        }
        $this->TripMinOfferQty = $tripMinOfferQty;
        return $this;
    }
    /**
     * Get TripMaxOfferQty value
     * @return int|null
     */
    public function getTripMaxOfferQty()
    {
        return $this->TripMaxOfferQty;
    }
    /**
     * Set TripMaxOfferQty value
     * @param int $tripMaxOfferQty
     * @return \StructType\Restriction
     */
    public function setTripMaxOfferQty($tripMaxOfferQty = null)
    {
        // validation for constraint: int
        if (!is_null($tripMaxOfferQty) && !(is_int($tripMaxOfferQty) || ctype_digit($tripMaxOfferQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tripMaxOfferQty, true), gettype($tripMaxOfferQty)), __LINE__);
        }
        $this->TripMaxOfferQty = $tripMaxOfferQty;
        return $this;
    }
    /**
     * Get TravelerMinOfferQty value
     * @return int|null
     */
    public function getTravelerMinOfferQty()
    {
        return $this->TravelerMinOfferQty;
    }
    /**
     * Set TravelerMinOfferQty value
     * @param int $travelerMinOfferQty
     * @return \StructType\Restriction
     */
    public function setTravelerMinOfferQty($travelerMinOfferQty = null)
    {
        // validation for constraint: int
        if (!is_null($travelerMinOfferQty) && !(is_int($travelerMinOfferQty) || ctype_digit($travelerMinOfferQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelerMinOfferQty, true), gettype($travelerMinOfferQty)), __LINE__);
        }
        $this->TravelerMinOfferQty = $travelerMinOfferQty;
        return $this;
    }
    /**
     * Get TravelerMaxOfferQty value
     * @return int|null
     */
    public function getTravelerMaxOfferQty()
    {
        return $this->TravelerMaxOfferQty;
    }
    /**
     * Set TravelerMaxOfferQty value
     * @param int $travelerMaxOfferQty
     * @return \StructType\Restriction
     */
    public function setTravelerMaxOfferQty($travelerMaxOfferQty = null)
    {
        // validation for constraint: int
        if (!is_null($travelerMaxOfferQty) && !(is_int($travelerMaxOfferQty) || ctype_digit($travelerMaxOfferQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelerMaxOfferQty, true), gettype($travelerMaxOfferQty)), __LINE__);
        }
        $this->TravelerMaxOfferQty = $travelerMaxOfferQty;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\Restriction
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDate, true), gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \StructType\Restriction
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get DOW_Restrictions value
     * @return mixed|null
     */
    public function getDOW_Restrictions()
    {
        return $this->DOW_Restrictions;
    }
    /**
     * Set DOW_Restrictions value
     * @param mixed $dOW_Restrictions
     * @return \StructType\Restriction
     */
    public function setDOW_Restrictions($dOW_Restrictions = null)
    {
        $this->DOW_Restrictions = $dOW_Restrictions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Restriction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
