<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestaurantsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides detailed information regarding restaurants.
 * @subpackage Structs
 */
class RestaurantsType extends AbstractStructBase
{
    /**
     * The Restaurant
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Restaurant[]
     */
    public $Restaurant;
    /**
     * The SrvcInfoCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SrvcInfoCodes
     */
    public $SrvcInfoCodes;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: Identifies the total number of food and beverage outlets for a property.
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for RestaurantsType
     * @uses RestaurantsType::setRestaurant()
     * @uses RestaurantsType::setSrvcInfoCodes()
     * @uses RestaurantsType::setQuantity()
     * @param \StructType\Restaurant[] $restaurant
     * @param \StructType\SrvcInfoCodes $srvcInfoCodes
     * @param int $quantity
     */
    public function __construct(array $restaurant = array(), \StructType\SrvcInfoCodes $srvcInfoCodes = null, $quantity = null)
    {
        $this
            ->setRestaurant($restaurant)
            ->setSrvcInfoCodes($srvcInfoCodes)
            ->setQuantity($quantity);
    }
    /**
     * Get Restaurant value
     * @return \StructType\Restaurant[]|null
     */
    public function getRestaurant()
    {
        return $this->Restaurant;
    }
    /**
     * This method is responsible for validating the values passed to the setRestaurant method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestaurant method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestaurantForArrayConstraintsFromSetRestaurant(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $restaurantsTypeRestaurantItem) {
            // validation for constraint: itemType
            if (!$restaurantsTypeRestaurantItem instanceof \StructType\Restaurant) {
                $invalidValues[] = is_object($restaurantsTypeRestaurantItem) ? get_class($restaurantsTypeRestaurantItem) : sprintf('%s(%s)', gettype($restaurantsTypeRestaurantItem), var_export($restaurantsTypeRestaurantItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restaurant property can only contain items of type \StructType\Restaurant, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restaurant value
     * @throws \InvalidArgumentException
     * @param \StructType\Restaurant[] $restaurant
     * @return \StructType\RestaurantsType
     */
    public function setRestaurant(array $restaurant = array())
    {
        // validation for constraint: array
        if ('' !== ($restaurantArrayErrorMessage = self::validateRestaurantForArrayConstraintsFromSetRestaurant($restaurant))) {
            throw new \InvalidArgumentException($restaurantArrayErrorMessage, __LINE__);
        }
        $this->Restaurant = $restaurant;
        return $this;
    }
    /**
     * Add item to Restaurant value
     * @throws \InvalidArgumentException
     * @param \StructType\Restaurant $item
     * @return \StructType\RestaurantsType
     */
    public function addToRestaurant(\StructType\Restaurant $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Restaurant) {
            throw new \InvalidArgumentException(sprintf('The Restaurant property can only contain items of type \StructType\Restaurant, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Restaurant[] = $item;
        return $this;
    }
    /**
     * Get SrvcInfoCodes value
     * @return \StructType\SrvcInfoCodes|null
     */
    public function getSrvcInfoCodes()
    {
        return $this->SrvcInfoCodes;
    }
    /**
     * Set SrvcInfoCodes value
     * @param \StructType\SrvcInfoCodes $srvcInfoCodes
     * @return \StructType\RestaurantsType
     */
    public function setSrvcInfoCodes(\StructType\SrvcInfoCodes $srvcInfoCodes = null)
    {
        $this->SrvcInfoCodes = $srvcInfoCodes;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\RestaurantsType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RestaurantsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
