<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Restaurant StructType
 * Meta information extracted from the WSDL
 * - documentation: When true, indicates a single restaurant is being removed. | Details of a specific restaurant such as type of restaurant, directions, schedules, etc.
 * @subpackage Structs
 */
class Restaurant extends RestaurantType
{
    /**
     * The Features
     * Meta information extracted from the WSDL
     * - documentation: Collection of features offered by a hotel.
     * - minOccurs: 0
     * @var mixed
     */
    public $Features;
    /**
     * The ContactInfos
     * Meta information extracted from the WSDL
     * - documentation: Collection of contact information (e.g., restaurant address, phone number).
     * - minOccurs: 0
     * @var mixed
     */
    public $ContactInfos;
    /**
     * The SrvcInfoCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SrvcInfoCodes
     */
    public $SrvcInfoCodes;
    /**
     * The AwardsRPH
     * Meta information extracted from the WSDL
     * - documentation: A reference to an award associated with this restaurant.
     * - use: optional
     * @var string
     */
    public $AwardsRPH;
    /**
     * Constructor method for Restaurant
     * @uses Restaurant::setFeatures()
     * @uses Restaurant::setContactInfos()
     * @uses Restaurant::setSrvcInfoCodes()
     * @uses Restaurant::setAwardsRPH()
     * @param mixed $features
     * @param mixed $contactInfos
     * @param \StructType\SrvcInfoCodes $srvcInfoCodes
     * @param string $awardsRPH
     */
    public function __construct($features = null, $contactInfos = null, \StructType\SrvcInfoCodes $srvcInfoCodes = null, $awardsRPH = null)
    {
        $this
            ->setFeatures($features)
            ->setContactInfos($contactInfos)
            ->setSrvcInfoCodes($srvcInfoCodes)
            ->setAwardsRPH($awardsRPH);
    }
    /**
     * Get Features value
     * @return mixed|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * Set Features value
     * @param mixed $features
     * @return \StructType\Restaurant
     */
    public function setFeatures($features = null)
    {
        $this->Features = $features;
        return $this;
    }
    /**
     * Get ContactInfos value
     * @return mixed|null
     */
    public function getContactInfos()
    {
        return $this->ContactInfos;
    }
    /**
     * Set ContactInfos value
     * @param mixed $contactInfos
     * @return \StructType\Restaurant
     */
    public function setContactInfos($contactInfos = null)
    {
        $this->ContactInfos = $contactInfos;
        return $this;
    }
    /**
     * Get SrvcInfoCodes value
     * @return \StructType\SrvcInfoCodes|null
     */
    public function getSrvcInfoCodes()
    {
        return $this->SrvcInfoCodes;
    }
    /**
     * Set SrvcInfoCodes value
     * @param \StructType\SrvcInfoCodes $srvcInfoCodes
     * @return \StructType\Restaurant
     */
    public function setSrvcInfoCodes(\StructType\SrvcInfoCodes $srvcInfoCodes = null)
    {
        $this->SrvcInfoCodes = $srvcInfoCodes;
        return $this;
    }
    /**
     * Get AwardsRPH value
     * @return string|null
     */
    public function getAwardsRPH()
    {
        return $this->AwardsRPH;
    }
    /**
     * Set AwardsRPH value
     * @param string $awardsRPH
     * @return \StructType\Restaurant
     */
    public function setAwardsRPH($awardsRPH = null)
    {
        // validation for constraint: string
        if (!is_null($awardsRPH) && !is_string($awardsRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($awardsRPH, true), gettype($awardsRPH)), __LINE__);
        }
        $this->AwardsRPH = $awardsRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Restaurant
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
