<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResBookDesignation StructType
 * Meta information extracted from the WSDL
 * - documentation: If the seat map display is requested for the cabin class in which a particular booking designator code (booking class) lies then that booking class can be specified in this element.
 * @subpackage Structs
 */
class ResBookDesignation extends AbstractStructBase
{
    /**
     * The ResBookDesigCode
     * Meta information extracted from the WSDL
     * - documentation: If the booking class is know for which the seat map is to be requested then the specific Booking class code can be entered here. The response will have the seat map for the cabin class in which the said booking classcode belongs.
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * Constructor method for ResBookDesignation
     * @uses ResBookDesignation::setResBookDesigCode()
     * @param string $resBookDesigCode
     */
    public function __construct($resBookDesigCode = null)
    {
        $this
            ->setResBookDesigCode($resBookDesigCode);
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \StructType\ResBookDesignation
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resBookDesigCode, true), gettype($resBookDesigCode)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResBookDesignation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
