<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestedOffer StructType
 * Meta information extracted from the WSDL
 * - documentation: Requested offer information.
 * @subpackage Structs
 */
class RequestedOffer extends AbstractStructBase
{
    /**
     * The NumberInParty
     * Meta information extracted from the WSDL
     * - documentation: Note: This is the total quantity of travelers that must be accommodated in the offer response. | Example: 2 | Total traveler quantity.
     * - use: required
     * @var int
     */
    public $NumberInParty;
    /**
     * The OfferTypes
     * Meta information extracted from the WSDL
     * - documentation: One or more offer types to be included or excluded in the response.
     * @var mixed
     */
    public $OfferTypes;
    /**
     * The TimePeriod
     * @var \StructType\TimePeriod
     */
    public $TimePeriod;
    /**
     * The GuidelinePricing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\GuidelinePricing
     */
    public $GuidelinePricing;
    /**
     * The TripPurpose
     * Meta information extracted from the WSDL
     * - documentation: Trip purpose.
     * - minOccurs: 0
     * @var mixed
     */
    public $TripPurpose;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * Constructor method for RequestedOffer
     * @uses RequestedOffer::setNumberInParty()
     * @uses RequestedOffer::setOfferTypes()
     * @uses RequestedOffer::setTimePeriod()
     * @uses RequestedOffer::setGuidelinePricing()
     * @uses RequestedOffer::setTripPurpose()
     * @uses RequestedOffer::setOntologyExtension()
     * @param int $numberInParty
     * @param mixed $offerTypes
     * @param \StructType\TimePeriod $timePeriod
     * @param \StructType\GuidelinePricing $guidelinePricing
     * @param mixed $tripPurpose
     * @param mixed $ontologyExtension
     */
    public function __construct($numberInParty = null, $offerTypes = null, \StructType\TimePeriod $timePeriod = null, \StructType\GuidelinePricing $guidelinePricing = null, $tripPurpose = null, $ontologyExtension = null)
    {
        $this
            ->setNumberInParty($numberInParty)
            ->setOfferTypes($offerTypes)
            ->setTimePeriod($timePeriod)
            ->setGuidelinePricing($guidelinePricing)
            ->setTripPurpose($tripPurpose)
            ->setOntologyExtension($ontologyExtension);
    }
    /**
     * Get NumberInParty value
     * @return int
     */
    public function getNumberInParty()
    {
        return $this->NumberInParty;
    }
    /**
     * Set NumberInParty value
     * @param int $numberInParty
     * @return \StructType\RequestedOffer
     */
    public function setNumberInParty($numberInParty = null)
    {
        // validation for constraint: int
        if (!is_null($numberInParty) && !(is_int($numberInParty) || ctype_digit($numberInParty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberInParty, true), gettype($numberInParty)), __LINE__);
        }
        $this->NumberInParty = $numberInParty;
        return $this;
    }
    /**
     * Get OfferTypes value
     * @return mixed|null
     */
    public function getOfferTypes()
    {
        return $this->OfferTypes;
    }
    /**
     * Set OfferTypes value
     * @param mixed $offerTypes
     * @return \StructType\RequestedOffer
     */
    public function setOfferTypes($offerTypes = null)
    {
        $this->OfferTypes = $offerTypes;
        return $this;
    }
    /**
     * Get TimePeriod value
     * @return \StructType\TimePeriod|null
     */
    public function getTimePeriod()
    {
        return $this->TimePeriod;
    }
    /**
     * Set TimePeriod value
     * @param \StructType\TimePeriod $timePeriod
     * @return \StructType\RequestedOffer
     */
    public function setTimePeriod(\StructType\TimePeriod $timePeriod = null)
    {
        $this->TimePeriod = $timePeriod;
        return $this;
    }
    /**
     * Get GuidelinePricing value
     * @return \StructType\GuidelinePricing|null
     */
    public function getGuidelinePricing()
    {
        return $this->GuidelinePricing;
    }
    /**
     * Set GuidelinePricing value
     * @param \StructType\GuidelinePricing $guidelinePricing
     * @return \StructType\RequestedOffer
     */
    public function setGuidelinePricing(\StructType\GuidelinePricing $guidelinePricing = null)
    {
        $this->GuidelinePricing = $guidelinePricing;
        return $this;
    }
    /**
     * Get TripPurpose value
     * @return mixed|null
     */
    public function getTripPurpose()
    {
        return $this->TripPurpose;
    }
    /**
     * Set TripPurpose value
     * @param mixed $tripPurpose
     * @return \StructType\RequestedOffer
     */
    public function setTripPurpose($tripPurpose = null)
    {
        $this->TripPurpose = $tripPurpose;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\RequestedOffer
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RequestedOffer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
