<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReissuedFlown StructType
 * Meta information extracted from the WSDL
 * - documentation: The reissued flown flight coupon information.
 * @subpackage Structs
 */
class ReissuedFlown extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: Coupon number.
     * - use: required
     * @var int
     */
    public $Number;
    /**
     * The TicketDocumentNbr
     * Meta information extracted from the WSDL
     * - documentation: Document number comprised of the airline code, form code, and serial number.
     * - use: required
     * @var string
     */
    public $TicketDocumentNbr;
    /**
     * The FlightSegmentRPH
     * Meta information extracted from the WSDL
     * - documentation: Reference to the flight segments for this coupon.
     * - minOccurs: 0
     * @var mixed
     */
    public $FlightSegmentRPH;
    /**
     * The CouponItinerarySeqNbr
     * Meta information extracted from the WSDL
     * - documentation: The number representing the order in which this coupon was used or is to be used.
     * - use: optional
     * @var int
     */
    public $CouponItinerarySeqNbr;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - documentation: The applicable fare basis code.
     * - use: optional
     * @var string
     */
    public $FareBasisCode;
    /**
     * The DateOfIssue
     * Meta information extracted from the WSDL
     * - documentation: The date the ticket was issued.
     * - use: optional
     * @var string
     */
    public $DateOfIssue;
    /**
     * The WaiverCode
     * Meta information extracted from the WSDL
     * - documentation: A validating carrier assigned code allowing a fare rule modification or override applied to a flown coupon from the ticket being reissued.
     * - use: optional
     * @var string
     */
    public $WaiverCode;
    /**
     * The TicketDesignatorCode
     * Meta information extracted from the WSDL
     * - documentation: The applicable code as provided for in ATA SIPP Reso 110.16 or IATA Reso 728, for each flown coupon from the ticket being reissued.
     * - use: optional
     * @var string
     */
    public $TicketDesignatorCode;
    /**
     * Constructor method for ReissuedFlown
     * @uses ReissuedFlown::setNumber()
     * @uses ReissuedFlown::setTicketDocumentNbr()
     * @uses ReissuedFlown::setFlightSegmentRPH()
     * @uses ReissuedFlown::setCouponItinerarySeqNbr()
     * @uses ReissuedFlown::setFareBasisCode()
     * @uses ReissuedFlown::setDateOfIssue()
     * @uses ReissuedFlown::setWaiverCode()
     * @uses ReissuedFlown::setTicketDesignatorCode()
     * @param int $number
     * @param string $ticketDocumentNbr
     * @param mixed $flightSegmentRPH
     * @param int $couponItinerarySeqNbr
     * @param string $fareBasisCode
     * @param string $dateOfIssue
     * @param string $waiverCode
     * @param string $ticketDesignatorCode
     */
    public function __construct($number = null, $ticketDocumentNbr = null, $flightSegmentRPH = null, $couponItinerarySeqNbr = null, $fareBasisCode = null, $dateOfIssue = null, $waiverCode = null, $ticketDesignatorCode = null)
    {
        $this
            ->setNumber($number)
            ->setTicketDocumentNbr($ticketDocumentNbr)
            ->setFlightSegmentRPH($flightSegmentRPH)
            ->setCouponItinerarySeqNbr($couponItinerarySeqNbr)
            ->setFareBasisCode($fareBasisCode)
            ->setDateOfIssue($dateOfIssue)
            ->setWaiverCode($waiverCode)
            ->setTicketDesignatorCode($ticketDesignatorCode);
    }
    /**
     * Get Number value
     * @return int
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\ReissuedFlown
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get TicketDocumentNbr value
     * @return string
     */
    public function getTicketDocumentNbr()
    {
        return $this->TicketDocumentNbr;
    }
    /**
     * Set TicketDocumentNbr value
     * @param string $ticketDocumentNbr
     * @return \StructType\ReissuedFlown
     */
    public function setTicketDocumentNbr($ticketDocumentNbr = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDocumentNbr) && !is_string($ticketDocumentNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDocumentNbr, true), gettype($ticketDocumentNbr)), __LINE__);
        }
        $this->TicketDocumentNbr = $ticketDocumentNbr;
        return $this;
    }
    /**
     * Get FlightSegmentRPH value
     * @return mixed|null
     */
    public function getFlightSegmentRPH()
    {
        return $this->FlightSegmentRPH;
    }
    /**
     * Set FlightSegmentRPH value
     * @param mixed $flightSegmentRPH
     * @return \StructType\ReissuedFlown
     */
    public function setFlightSegmentRPH($flightSegmentRPH = null)
    {
        $this->FlightSegmentRPH = $flightSegmentRPH;
        return $this;
    }
    /**
     * Get CouponItinerarySeqNbr value
     * @return int|null
     */
    public function getCouponItinerarySeqNbr()
    {
        return $this->CouponItinerarySeqNbr;
    }
    /**
     * Set CouponItinerarySeqNbr value
     * @param int $couponItinerarySeqNbr
     * @return \StructType\ReissuedFlown
     */
    public function setCouponItinerarySeqNbr($couponItinerarySeqNbr = null)
    {
        // validation for constraint: int
        if (!is_null($couponItinerarySeqNbr) && !(is_int($couponItinerarySeqNbr) || ctype_digit($couponItinerarySeqNbr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($couponItinerarySeqNbr, true), gettype($couponItinerarySeqNbr)), __LINE__);
        }
        $this->CouponItinerarySeqNbr = $couponItinerarySeqNbr;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \StructType\ReissuedFlown
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get DateOfIssue value
     * @return string|null
     */
    public function getDateOfIssue()
    {
        return $this->DateOfIssue;
    }
    /**
     * Set DateOfIssue value
     * @param string $dateOfIssue
     * @return \StructType\ReissuedFlown
     */
    public function setDateOfIssue($dateOfIssue = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfIssue) && !is_string($dateOfIssue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfIssue, true), gettype($dateOfIssue)), __LINE__);
        }
        $this->DateOfIssue = $dateOfIssue;
        return $this;
    }
    /**
     * Get WaiverCode value
     * @return string|null
     */
    public function getWaiverCode()
    {
        return $this->WaiverCode;
    }
    /**
     * Set WaiverCode value
     * @param string $waiverCode
     * @return \StructType\ReissuedFlown
     */
    public function setWaiverCode($waiverCode = null)
    {
        // validation for constraint: string
        if (!is_null($waiverCode) && !is_string($waiverCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waiverCode, true), gettype($waiverCode)), __LINE__);
        }
        $this->WaiverCode = $waiverCode;
        return $this;
    }
    /**
     * Get TicketDesignatorCode value
     * @return string|null
     */
    public function getTicketDesignatorCode()
    {
        return $this->TicketDesignatorCode;
    }
    /**
     * Set TicketDesignatorCode value
     * @param string $ticketDesignatorCode
     * @return \StructType\ReissuedFlown
     */
    public function setTicketDesignatorCode($ticketDesignatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignatorCode) && !is_string($ticketDesignatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDesignatorCode, true), gettype($ticketDesignatorCode)), __LINE__);
        }
        $this->TicketDesignatorCode = $ticketDesignatorCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReissuedFlown
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
