<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recycling StructType
 * Meta information extracted from the WSDL
 * - documentation: Recycling information.
 * @subpackage Structs
 */
class Recycling extends AbstractStructBase
{
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Details
     */
    public $Details;
    /**
     * The ProgramDescription
     * Meta information extracted from the WSDL
     * - documentation: Recycling program description.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $ProgramDescription;
    /**
     * The ActiveProgramInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the property has an active recycling program. | Example: true | Active recycling program indicator.
     * - use: optional
     * @var bool
     */
    public $ActiveProgramInd;
    /**
     * The EcologicalDishwareInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, the property uses cups, glasses, dishes, tableware and other items are long-lasting and not disposable. | Example: true | Non-disposable dishware indicator.
     * - use: optional
     * @var bool
     */
    public $EcologicalDishwareInd;
    /**
     * Constructor method for Recycling
     * @uses Recycling::setDetails()
     * @uses Recycling::setProgramDescription()
     * @uses Recycling::setActiveProgramInd()
     * @uses Recycling::setEcologicalDishwareInd()
     * @param \StructType\Details $details
     * @param mixed[] $programDescription
     * @param bool $activeProgramInd
     * @param bool $ecologicalDishwareInd
     */
    public function __construct(\StructType\Details $details = null, array $programDescription = array(), $activeProgramInd = null, $ecologicalDishwareInd = null)
    {
        $this
            ->setDetails($details)
            ->setProgramDescription($programDescription)
            ->setActiveProgramInd($activeProgramInd)
            ->setEcologicalDishwareInd($ecologicalDishwareInd);
    }
    /**
     * Get Details value
     * @return \StructType\Details|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \StructType\Details $details
     * @return \StructType\Recycling
     */
    public function setDetails(\StructType\Details $details = null)
    {
        $this->Details = $details;
        return $this;
    }
    /**
     * Get ProgramDescription value
     * @return mixed[]|null
     */
    public function getProgramDescription()
    {
        return $this->ProgramDescription;
    }
    /**
     * This method is responsible for validating the values passed to the setProgramDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProgramDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProgramDescriptionForArrayConstraintsFromSetProgramDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recyclingProgramDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($recyclingProgramDescriptionItem) ? get_class($recyclingProgramDescriptionItem) : sprintf('%s(%s)', gettype($recyclingProgramDescriptionItem), var_export($recyclingProgramDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProgramDescription property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProgramDescription value
     * @throws \InvalidArgumentException
     * @param mixed[] $programDescription
     * @return \StructType\Recycling
     */
    public function setProgramDescription(array $programDescription = array())
    {
        // validation for constraint: array
        if ('' !== ($programDescriptionArrayErrorMessage = self::validateProgramDescriptionForArrayConstraintsFromSetProgramDescription($programDescription))) {
            throw new \InvalidArgumentException($programDescriptionArrayErrorMessage, __LINE__);
        }
        $this->ProgramDescription = $programDescription;
        return $this;
    }
    /**
     * Add item to ProgramDescription value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Recycling
     */
    public function addToProgramDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The ProgramDescription property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProgramDescription[] = $item;
        return $this;
    }
    /**
     * Get ActiveProgramInd value
     * @return bool|null
     */
    public function getActiveProgramInd()
    {
        return $this->ActiveProgramInd;
    }
    /**
     * Set ActiveProgramInd value
     * @param bool $activeProgramInd
     * @return \StructType\Recycling
     */
    public function setActiveProgramInd($activeProgramInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($activeProgramInd) && !is_bool($activeProgramInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activeProgramInd, true), gettype($activeProgramInd)), __LINE__);
        }
        $this->ActiveProgramInd = $activeProgramInd;
        return $this;
    }
    /**
     * Get EcologicalDishwareInd value
     * @return bool|null
     */
    public function getEcologicalDishwareInd()
    {
        return $this->EcologicalDishwareInd;
    }
    /**
     * Set EcologicalDishwareInd value
     * @param bool $ecologicalDishwareInd
     * @return \StructType\Recycling
     */
    public function setEcologicalDishwareInd($ecologicalDishwareInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($ecologicalDishwareInd) && !is_bool($ecologicalDishwareInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ecologicalDishwareInd, true), gettype($ecologicalDishwareInd)), __LINE__);
        }
        $this->EcologicalDishwareInd = $ecologicalDishwareInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Recycling
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
