<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecreationDetails StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of recreation details.
 * @subpackage Structs
 */
class RecreationDetails extends AbstractStructBase
{
    /**
     * The RecreationDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\RecreationDetail[]
     */
    public $RecreationDetail;
    /**
     * Constructor method for RecreationDetails
     * @uses RecreationDetails::setRecreationDetail()
     * @param \StructType\RecreationDetail[] $recreationDetail
     */
    public function __construct(array $recreationDetail = array())
    {
        $this
            ->setRecreationDetail($recreationDetail);
    }
    /**
     * Get RecreationDetail value
     * @return \StructType\RecreationDetail[]|null
     */
    public function getRecreationDetail()
    {
        return $this->RecreationDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setRecreationDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecreationDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecreationDetailForArrayConstraintsFromSetRecreationDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recreationDetailsRecreationDetailItem) {
            // validation for constraint: itemType
            if (!$recreationDetailsRecreationDetailItem instanceof \StructType\RecreationDetail) {
                $invalidValues[] = is_object($recreationDetailsRecreationDetailItem) ? get_class($recreationDetailsRecreationDetailItem) : sprintf('%s(%s)', gettype($recreationDetailsRecreationDetailItem), var_export($recreationDetailsRecreationDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RecreationDetail property can only contain items of type \StructType\RecreationDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RecreationDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RecreationDetail[] $recreationDetail
     * @return \StructType\RecreationDetails
     */
    public function setRecreationDetail(array $recreationDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($recreationDetailArrayErrorMessage = self::validateRecreationDetailForArrayConstraintsFromSetRecreationDetail($recreationDetail))) {
            throw new \InvalidArgumentException($recreationDetailArrayErrorMessage, __LINE__);
        }
        $this->RecreationDetail = $recreationDetail;
        return $this;
    }
    /**
     * Add item to RecreationDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\RecreationDetail $item
     * @return \StructType\RecreationDetails
     */
    public function addToRecreationDetail(\StructType\RecreationDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RecreationDetail) {
            throw new \InvalidArgumentException(sprintf('The RecreationDetail property can only contain items of type \StructType\RecreationDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RecreationDetail[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RecreationDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
