<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Recreation StructType
 * Meta information extracted from the WSDL
 * - documentation: This may be used to uniquely identify a recreational facility. | A recreation facility available to the guest. These may or may not be operated by the hotel or located at the hotel. | Identifies recreation facilities or amenities of
 * interest.
 * @subpackage Structs
 */
class Recreation extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Recreation Srvc Type (RST). | Used to identify a specific recreation activity. Refer to OpenTravel Code list Recreation Srvc Type (RST).
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - documentation: Used to pass contact information of a specific recreation facility.
     * - minOccurs: 0
     * @var mixed
     */
    public $Contact;
    /**
     * The OperationSchedules
     * Meta information extracted from the WSDL
     * - documentation: Collection of days, times, and fees.
     * - minOccurs: 0
     * @var mixed
     */
    public $OperationSchedules;
    /**
     * The RefPoints
     * Meta information extracted from the WSDL
     * - documentation: Identifies where the recreation facility is located.
     * - minOccurs: 0
     * @var mixed
     */
    public $RefPoints;
    /**
     * The MultimediaDescriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MultimediaDescriptions
     */
    public $MultimediaDescriptions;
    /**
     * The RecreationDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecreationDetails
     */
    public $RecreationDetails;
    /**
     * The DescriptiveText
     * Meta information extracted from the WSDL
     * - documentation: Descriptive text that describes the recreation facility.
     * - minOccurs: 0
     * @var string
     */
    public $DescriptiveText;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the recreation.
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The ProximityCode
     * Meta information extracted from the WSDL
     * - documentation: Denotes whether a recreation is onsite, offsite or information is not available. Refer to OpenTravel Code Table Proximity (PRX).
     * - use: optional
     * @var string
     */
    public $ProximityCode;
    /**
     * The Included
     * Meta information extracted from the WSDL
     * - documentation: If TRUE, this recreation is included with basic room rates.
     * - use: optional
     * @var bool
     */
    public $Included;
    /**
     * The ExistsCode
     * Meta information extracted from the WSDL
     * - documentation: This attribute is used to explicitly define whether an amenity or service is offered. Refer to OpenTravel Code list Option Type Code (OTC). This is used in conjunction with Code.
     * - use: optional
     * @var string
     */
    public $ExistsCode;
    /**
     * The Sort
     * Meta information extracted from the WSDL
     * - documentation: Used to define the display order.
     * - use: optional
     * @var int
     */
    public $Sort;
    /**
     * The YearReplaced
     * Meta information extracted from the WSDL
     * - documentation: The year when recreation associated equipment was last replaced.
     * - use: optional
     * @var string
     */
    public $YearReplaced;
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - documentation: Identifies the language in which the attraction information is sent.
     * - use: optional
     * @var string
     */
    public $Language;
    /**
     * The FeaturedInd
     * Meta information extracted from the WSDL
     * - documentation: Example: true | If true, this is a featured recreation for the property.
     * @var bool
     */
    public $FeaturedInd;
    /**
     * Constructor method for Recreation
     * @uses Recreation::setCode()
     * @uses Recreation::setContact()
     * @uses Recreation::setOperationSchedules()
     * @uses Recreation::setRefPoints()
     * @uses Recreation::setMultimediaDescriptions()
     * @uses Recreation::setRecreationDetails()
     * @uses Recreation::setDescriptiveText()
     * @uses Recreation::setName()
     * @uses Recreation::setProximityCode()
     * @uses Recreation::setIncluded()
     * @uses Recreation::setExistsCode()
     * @uses Recreation::setSort()
     * @uses Recreation::setYearReplaced()
     * @uses Recreation::setLanguage()
     * @uses Recreation::setFeaturedInd()
     * @param string $code
     * @param mixed $contact
     * @param mixed $operationSchedules
     * @param mixed $refPoints
     * @param \StructType\MultimediaDescriptions $multimediaDescriptions
     * @param \StructType\RecreationDetails $recreationDetails
     * @param string $descriptiveText
     * @param string $name
     * @param string $proximityCode
     * @param bool $included
     * @param string $existsCode
     * @param int $sort
     * @param string $yearReplaced
     * @param string $language
     * @param bool $featuredInd
     */
    public function __construct($code = null, $contact = null, $operationSchedules = null, $refPoints = null, \StructType\MultimediaDescriptions $multimediaDescriptions = null, \StructType\RecreationDetails $recreationDetails = null, $descriptiveText = null, $name = null, $proximityCode = null, $included = null, $existsCode = null, $sort = null, $yearReplaced = null, $language = null, $featuredInd = null)
    {
        $this
            ->setCode($code)
            ->setContact($contact)
            ->setOperationSchedules($operationSchedules)
            ->setRefPoints($refPoints)
            ->setMultimediaDescriptions($multimediaDescriptions)
            ->setRecreationDetails($recreationDetails)
            ->setDescriptiveText($descriptiveText)
            ->setName($name)
            ->setProximityCode($proximityCode)
            ->setIncluded($included)
            ->setExistsCode($existsCode)
            ->setSort($sort)
            ->setYearReplaced($yearReplaced)
            ->setLanguage($language)
            ->setFeaturedInd($featuredInd);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\Recreation
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Contact value
     * @return mixed|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param mixed $contact
     * @return \StructType\Recreation
     */
    public function setContact($contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get OperationSchedules value
     * @return mixed|null
     */
    public function getOperationSchedules()
    {
        return $this->OperationSchedules;
    }
    /**
     * Set OperationSchedules value
     * @param mixed $operationSchedules
     * @return \StructType\Recreation
     */
    public function setOperationSchedules($operationSchedules = null)
    {
        $this->OperationSchedules = $operationSchedules;
        return $this;
    }
    /**
     * Get RefPoints value
     * @return mixed|null
     */
    public function getRefPoints()
    {
        return $this->RefPoints;
    }
    /**
     * Set RefPoints value
     * @param mixed $refPoints
     * @return \StructType\Recreation
     */
    public function setRefPoints($refPoints = null)
    {
        $this->RefPoints = $refPoints;
        return $this;
    }
    /**
     * Get MultimediaDescriptions value
     * @return \StructType\MultimediaDescriptions|null
     */
    public function getMultimediaDescriptions()
    {
        return $this->MultimediaDescriptions;
    }
    /**
     * Set MultimediaDescriptions value
     * @param \StructType\MultimediaDescriptions $multimediaDescriptions
     * @return \StructType\Recreation
     */
    public function setMultimediaDescriptions(\StructType\MultimediaDescriptions $multimediaDescriptions = null)
    {
        $this->MultimediaDescriptions = $multimediaDescriptions;
        return $this;
    }
    /**
     * Get RecreationDetails value
     * @return \StructType\RecreationDetails|null
     */
    public function getRecreationDetails()
    {
        return $this->RecreationDetails;
    }
    /**
     * Set RecreationDetails value
     * @param \StructType\RecreationDetails $recreationDetails
     * @return \StructType\Recreation
     */
    public function setRecreationDetails(\StructType\RecreationDetails $recreationDetails = null)
    {
        $this->RecreationDetails = $recreationDetails;
        return $this;
    }
    /**
     * Get DescriptiveText value
     * @return string|null
     */
    public function getDescriptiveText()
    {
        return $this->DescriptiveText;
    }
    /**
     * Set DescriptiveText value
     * @param string $descriptiveText
     * @return \StructType\Recreation
     */
    public function setDescriptiveText($descriptiveText = null)
    {
        // validation for constraint: string
        if (!is_null($descriptiveText) && !is_string($descriptiveText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptiveText, true), gettype($descriptiveText)), __LINE__);
        }
        $this->DescriptiveText = $descriptiveText;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Recreation
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ProximityCode value
     * @return string|null
     */
    public function getProximityCode()
    {
        return $this->ProximityCode;
    }
    /**
     * Set ProximityCode value
     * @param string $proximityCode
     * @return \StructType\Recreation
     */
    public function setProximityCode($proximityCode = null)
    {
        // validation for constraint: string
        if (!is_null($proximityCode) && !is_string($proximityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proximityCode, true), gettype($proximityCode)), __LINE__);
        }
        $this->ProximityCode = $proximityCode;
        return $this;
    }
    /**
     * Get Included value
     * @return bool|null
     */
    public function getIncluded()
    {
        return $this->Included;
    }
    /**
     * Set Included value
     * @param bool $included
     * @return \StructType\Recreation
     */
    public function setIncluded($included = null)
    {
        // validation for constraint: boolean
        if (!is_null($included) && !is_bool($included)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($included, true), gettype($included)), __LINE__);
        }
        $this->Included = $included;
        return $this;
    }
    /**
     * Get ExistsCode value
     * @return string|null
     */
    public function getExistsCode()
    {
        return $this->ExistsCode;
    }
    /**
     * Set ExistsCode value
     * @param string $existsCode
     * @return \StructType\Recreation
     */
    public function setExistsCode($existsCode = null)
    {
        // validation for constraint: string
        if (!is_null($existsCode) && !is_string($existsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($existsCode, true), gettype($existsCode)), __LINE__);
        }
        $this->ExistsCode = $existsCode;
        return $this;
    }
    /**
     * Get Sort value
     * @return int|null
     */
    public function getSort()
    {
        return $this->Sort;
    }
    /**
     * Set Sort value
     * @param int $sort
     * @return \StructType\Recreation
     */
    public function setSort($sort = null)
    {
        // validation for constraint: int
        if (!is_null($sort) && !(is_int($sort) || ctype_digit($sort))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sort, true), gettype($sort)), __LINE__);
        }
        $this->Sort = $sort;
        return $this;
    }
    /**
     * Get YearReplaced value
     * @return string|null
     */
    public function getYearReplaced()
    {
        return $this->YearReplaced;
    }
    /**
     * Set YearReplaced value
     * @param string $yearReplaced
     * @return \StructType\Recreation
     */
    public function setYearReplaced($yearReplaced = null)
    {
        // validation for constraint: string
        if (!is_null($yearReplaced) && !is_string($yearReplaced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yearReplaced, true), gettype($yearReplaced)), __LINE__);
        }
        $this->YearReplaced = $yearReplaced;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\Recreation
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get FeaturedInd value
     * @return bool|null
     */
    public function getFeaturedInd()
    {
        return $this->FeaturedInd;
    }
    /**
     * Set FeaturedInd value
     * @param bool $featuredInd
     * @return \StructType\Recreation
     */
    public function setFeaturedInd($featuredInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($featuredInd) && !is_bool($featuredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($featuredInd, true), gettype($featuredInd)), __LINE__);
        }
        $this->FeaturedInd = $featuredInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Recreation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
