<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RebatePrograms StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of rebate programs the hotel participates in.
 * @subpackage Structs
 */
class RebatePrograms extends AbstractStructBase
{
    /**
     * The RebateProgram
     * Meta information extracted from the WSDL
     * - documentation: Information about a rebate program the hotel participates in, such as "Value Added Tax" (VAT).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $RebateProgram;
    /**
     * Constructor method for RebatePrograms
     * @uses RebatePrograms::setRebateProgram()
     * @param mixed[] $rebateProgram
     */
    public function __construct(array $rebateProgram = array())
    {
        $this
            ->setRebateProgram($rebateProgram);
    }
    /**
     * Get RebateProgram value
     * @return mixed[]|null
     */
    public function getRebateProgram()
    {
        return $this->RebateProgram;
    }
    /**
     * This method is responsible for validating the values passed to the setRebateProgram method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRebateProgram method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRebateProgramForArrayConstraintsFromSetRebateProgram(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rebateProgramsRebateProgramItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($rebateProgramsRebateProgramItem) ? get_class($rebateProgramsRebateProgramItem) : sprintf('%s(%s)', gettype($rebateProgramsRebateProgramItem), var_export($rebateProgramsRebateProgramItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RebateProgram property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RebateProgram value
     * @throws \InvalidArgumentException
     * @param mixed[] $rebateProgram
     * @return \StructType\RebatePrograms
     */
    public function setRebateProgram(array $rebateProgram = array())
    {
        // validation for constraint: array
        if ('' !== ($rebateProgramArrayErrorMessage = self::validateRebateProgramForArrayConstraintsFromSetRebateProgram($rebateProgram))) {
            throw new \InvalidArgumentException($rebateProgramArrayErrorMessage, __LINE__);
        }
        $this->RebateProgram = $rebateProgram;
        return $this;
    }
    /**
     * Add item to RebateProgram value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RebatePrograms
     */
    public function addToRebateProgram($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RebateProgram property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RebateProgram[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RebatePrograms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
