<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadRequests StructType
 * Meta information extracted from the WSDL
 * - documentation: A grouping of Read Requests by travel vertical.
 * @subpackage Structs
 */
class ReadRequests extends AbstractStructBase
{
    /**
     * The ReadRequest
     * Meta information extracted from the WSDL
     * - choice: ReadRequest | GlobalReservationReadRequest | AirReadRequest | CruiseReadRequest | GolfReadRequest | HotelReadRequest | PkgReadRequest | ProfileReadRequest | RailReadRequest | VehicleReadRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ReadRequest[]
     */
    public $ReadRequest;
    /**
     * The GlobalReservationReadRequest
     * Meta information extracted from the WSDL
     * - choice: ReadRequest | GlobalReservationReadRequest | AirReadRequest | CruiseReadRequest | GolfReadRequest | HotelReadRequest | PkgReadRequest | ProfileReadRequest | RailReadRequest | VehicleReadRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GlobalReservationReadRequest[]
     */
    public $GlobalReservationReadRequest;
    /**
     * The AirReadRequest
     * Meta information extracted from the WSDL
     * - choice: ReadRequest | GlobalReservationReadRequest | AirReadRequest | CruiseReadRequest | GolfReadRequest | HotelReadRequest | PkgReadRequest | ProfileReadRequest | RailReadRequest | VehicleReadRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AirReadRequest[]
     */
    public $AirReadRequest;
    /**
     * The CruiseReadRequest
     * Meta information extracted from the WSDL
     * - choice: ReadRequest | GlobalReservationReadRequest | AirReadRequest | CruiseReadRequest | GolfReadRequest | HotelReadRequest | PkgReadRequest | ProfileReadRequest | RailReadRequest | VehicleReadRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\CruiseReadRequest[]
     */
    public $CruiseReadRequest;
    /**
     * The GolfReadRequest
     * Meta information extracted from the WSDL
     * - choice: ReadRequest | GlobalReservationReadRequest | AirReadRequest | CruiseReadRequest | GolfReadRequest | HotelReadRequest | PkgReadRequest | ProfileReadRequest | RailReadRequest | VehicleReadRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GolfReadRequest[]
     */
    public $GolfReadRequest;
    /**
     * The HotelReadRequest
     * Meta information extracted from the WSDL
     * - choice: ReadRequest | GlobalReservationReadRequest | AirReadRequest | CruiseReadRequest | GolfReadRequest | HotelReadRequest | PkgReadRequest | ProfileReadRequest | RailReadRequest | VehicleReadRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HotelReadRequest[]
     */
    public $HotelReadRequest;
    /**
     * The PkgReadRequest
     * Meta information extracted from the WSDL
     * - choice: ReadRequest | GlobalReservationReadRequest | AirReadRequest | CruiseReadRequest | GolfReadRequest | HotelReadRequest | PkgReadRequest | ProfileReadRequest | RailReadRequest | VehicleReadRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PkgReadRequest[]
     */
    public $PkgReadRequest;
    /**
     * The ProfileReadRequest
     * Meta information extracted from the WSDL
     * - choice: ReadRequest | GlobalReservationReadRequest | AirReadRequest | CruiseReadRequest | GolfReadRequest | HotelReadRequest | PkgReadRequest | ProfileReadRequest | RailReadRequest | VehicleReadRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProfileReadRequest[]
     */
    public $ProfileReadRequest;
    /**
     * The RailReadRequest
     * Meta information extracted from the WSDL
     * - choice: ReadRequest | GlobalReservationReadRequest | AirReadRequest | CruiseReadRequest | GolfReadRequest | HotelReadRequest | PkgReadRequest | ProfileReadRequest | RailReadRequest | VehicleReadRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RailReadRequest[]
     */
    public $RailReadRequest;
    /**
     * The VehicleReadRequest
     * Meta information extracted from the WSDL
     * - choice: ReadRequest | GlobalReservationReadRequest | AirReadRequest | CruiseReadRequest | GolfReadRequest | HotelReadRequest | PkgReadRequest | ProfileReadRequest | RailReadRequest | VehicleReadRequest
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VehicleReadRequest[]
     */
    public $VehicleReadRequest;
    /**
     * Constructor method for ReadRequests
     * @uses ReadRequests::setReadRequest()
     * @uses ReadRequests::setGlobalReservationReadRequest()
     * @uses ReadRequests::setAirReadRequest()
     * @uses ReadRequests::setCruiseReadRequest()
     * @uses ReadRequests::setGolfReadRequest()
     * @uses ReadRequests::setHotelReadRequest()
     * @uses ReadRequests::setPkgReadRequest()
     * @uses ReadRequests::setProfileReadRequest()
     * @uses ReadRequests::setRailReadRequest()
     * @uses ReadRequests::setVehicleReadRequest()
     * @param \StructType\ReadRequest[] $readRequest
     * @param \StructType\GlobalReservationReadRequest[] $globalReservationReadRequest
     * @param \StructType\AirReadRequest[] $airReadRequest
     * @param \StructType\CruiseReadRequest[] $cruiseReadRequest
     * @param \StructType\GolfReadRequest[] $golfReadRequest
     * @param \StructType\HotelReadRequest[] $hotelReadRequest
     * @param \StructType\PkgReadRequest[] $pkgReadRequest
     * @param \StructType\ProfileReadRequest[] $profileReadRequest
     * @param \StructType\RailReadRequest[] $railReadRequest
     * @param \StructType\VehicleReadRequest[] $vehicleReadRequest
     */
    public function __construct(array $readRequest = array(), array $globalReservationReadRequest = array(), array $airReadRequest = array(), array $cruiseReadRequest = array(), array $golfReadRequest = array(), array $hotelReadRequest = array(), array $pkgReadRequest = array(), array $profileReadRequest = array(), array $railReadRequest = array(), array $vehicleReadRequest = array())
    {
        $this
            ->setReadRequest($readRequest)
            ->setGlobalReservationReadRequest($globalReservationReadRequest)
            ->setAirReadRequest($airReadRequest)
            ->setCruiseReadRequest($cruiseReadRequest)
            ->setGolfReadRequest($golfReadRequest)
            ->setHotelReadRequest($hotelReadRequest)
            ->setPkgReadRequest($pkgReadRequest)
            ->setProfileReadRequest($profileReadRequest)
            ->setRailReadRequest($railReadRequest)
            ->setVehicleReadRequest($vehicleReadRequest);
    }
    /**
     * Get ReadRequest value
     * @return \StructType\ReadRequest[]|null
     */
    public function getReadRequest()
    {
        return isset($this->ReadRequest) ? $this->ReadRequest : null;
    }
    /**
     * This method is responsible for validating the values passed to the setReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReadRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReadRequestForArrayConstraintsFromSetReadRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readRequestsReadRequestItem) {
            // validation for constraint: itemType
            if (!$readRequestsReadRequestItem instanceof \StructType\ReadRequest) {
                $invalidValues[] = is_object($readRequestsReadRequestItem) ? get_class($readRequestsReadRequestItem) : sprintf('%s(%s)', gettype($readRequestsReadRequestItem), var_export($readRequestsReadRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReadRequest property can only contain items of type \StructType\ReadRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateReadRequestForChoiceConstraintsFromSetReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'GlobalReservationReadRequest',
            'AirReadRequest',
            'CruiseReadRequest',
            'GolfReadRequest',
            'HotelReadRequest',
            'PkgReadRequest',
            'ProfileReadRequest',
            'RailReadRequest',
            'VehicleReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: ReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ReadRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\ReadRequest[] $readRequest
     * @return \StructType\ReadRequests
     */
    public function setReadRequest(array $readRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($readRequestArrayErrorMessage = self::validateReadRequestForArrayConstraintsFromSetReadRequest($readRequest))) {
            throw new \InvalidArgumentException($readRequestArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($readRequestChoiceErrorMessage = self::validateReadRequestForChoiceConstraintsFromSetReadRequest($readRequest))) {
            throw new \InvalidArgumentException($readRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($readRequest) || (is_array($readRequest) && empty($readRequest))) {
            unset($this->ReadRequest);
        } else {
            $this->ReadRequest = $readRequest;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'GlobalReservationReadRequest',
            'AirReadRequest',
            'CruiseReadRequest',
            'GolfReadRequest',
            'HotelReadRequest',
            'PkgReadRequest',
            'ProfileReadRequest',
            'RailReadRequest',
            'VehicleReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: ReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to ReadRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\ReadRequest $item
     * @return \StructType\ReadRequests
     */
    public function addToReadRequest(\StructType\ReadRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReadRequest) {
            throw new \InvalidArgumentException(sprintf('The ReadRequest property can only contain items of type \StructType\ReadRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToReadRequest($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->ReadRequest[] = $item;
        return $this;
    }
    /**
     * Get GlobalReservationReadRequest value
     * @return \StructType\GlobalReservationReadRequest[]|null
     */
    public function getGlobalReservationReadRequest()
    {
        return isset($this->GlobalReservationReadRequest) ? $this->GlobalReservationReadRequest : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGlobalReservationReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGlobalReservationReadRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGlobalReservationReadRequestForArrayConstraintsFromSetGlobalReservationReadRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readRequestsGlobalReservationReadRequestItem) {
            // validation for constraint: itemType
            if (!$readRequestsGlobalReservationReadRequestItem instanceof \StructType\GlobalReservationReadRequest) {
                $invalidValues[] = is_object($readRequestsGlobalReservationReadRequestItem) ? get_class($readRequestsGlobalReservationReadRequestItem) : sprintf('%s(%s)', gettype($readRequestsGlobalReservationReadRequestItem), var_export($readRequestsGlobalReservationReadRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GlobalReservationReadRequest property can only contain items of type \StructType\GlobalReservationReadRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setGlobalReservationReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGlobalReservationReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGlobalReservationReadRequestForChoiceConstraintsFromSetGlobalReservationReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'AirReadRequest',
            'CruiseReadRequest',
            'GolfReadRequest',
            'HotelReadRequest',
            'PkgReadRequest',
            'ProfileReadRequest',
            'RailReadRequest',
            'VehicleReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GlobalReservationReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: GlobalReservationReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set GlobalReservationReadRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\GlobalReservationReadRequest[] $globalReservationReadRequest
     * @return \StructType\ReadRequests
     */
    public function setGlobalReservationReadRequest(array $globalReservationReadRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($globalReservationReadRequestArrayErrorMessage = self::validateGlobalReservationReadRequestForArrayConstraintsFromSetGlobalReservationReadRequest($globalReservationReadRequest))) {
            throw new \InvalidArgumentException($globalReservationReadRequestArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($globalReservationReadRequestChoiceErrorMessage = self::validateGlobalReservationReadRequestForChoiceConstraintsFromSetGlobalReservationReadRequest($globalReservationReadRequest))) {
            throw new \InvalidArgumentException($globalReservationReadRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($globalReservationReadRequest) || (is_array($globalReservationReadRequest) && empty($globalReservationReadRequest))) {
            unset($this->GlobalReservationReadRequest);
        } else {
            $this->GlobalReservationReadRequest = $globalReservationReadRequest;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToGlobalReservationReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToGlobalReservationReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToGlobalReservationReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'AirReadRequest',
            'CruiseReadRequest',
            'GolfReadRequest',
            'HotelReadRequest',
            'PkgReadRequest',
            'ProfileReadRequest',
            'RailReadRequest',
            'VehicleReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GlobalReservationReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: GlobalReservationReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to GlobalReservationReadRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\GlobalReservationReadRequest $item
     * @return \StructType\ReadRequests
     */
    public function addToGlobalReservationReadRequest(\StructType\GlobalReservationReadRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GlobalReservationReadRequest) {
            throw new \InvalidArgumentException(sprintf('The GlobalReservationReadRequest property can only contain items of type \StructType\GlobalReservationReadRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToGlobalReservationReadRequest($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->GlobalReservationReadRequest[] = $item;
        return $this;
    }
    /**
     * Get AirReadRequest value
     * @return \StructType\AirReadRequest[]|null
     */
    public function getAirReadRequest()
    {
        return isset($this->AirReadRequest) ? $this->AirReadRequest : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAirReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirReadRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirReadRequestForArrayConstraintsFromSetAirReadRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readRequestsAirReadRequestItem) {
            // validation for constraint: itemType
            if (!$readRequestsAirReadRequestItem instanceof \StructType\AirReadRequest) {
                $invalidValues[] = is_object($readRequestsAirReadRequestItem) ? get_class($readRequestsAirReadRequestItem) : sprintf('%s(%s)', gettype($readRequestsAirReadRequestItem), var_export($readRequestsAirReadRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirReadRequest property can only contain items of type \StructType\AirReadRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setAirReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAirReadRequestForChoiceConstraintsFromSetAirReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'GlobalReservationReadRequest',
            'CruiseReadRequest',
            'GolfReadRequest',
            'HotelReadRequest',
            'PkgReadRequest',
            'ProfileReadRequest',
            'RailReadRequest',
            'VehicleReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AirReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: AirReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AirReadRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\AirReadRequest[] $airReadRequest
     * @return \StructType\ReadRequests
     */
    public function setAirReadRequest(array $airReadRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($airReadRequestArrayErrorMessage = self::validateAirReadRequestForArrayConstraintsFromSetAirReadRequest($airReadRequest))) {
            throw new \InvalidArgumentException($airReadRequestArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($airReadRequestChoiceErrorMessage = self::validateAirReadRequestForChoiceConstraintsFromSetAirReadRequest($airReadRequest))) {
            throw new \InvalidArgumentException($airReadRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($airReadRequest) || (is_array($airReadRequest) && empty($airReadRequest))) {
            unset($this->AirReadRequest);
        } else {
            $this->AirReadRequest = $airReadRequest;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToAirReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToAirReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToAirReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'GlobalReservationReadRequest',
            'CruiseReadRequest',
            'GolfReadRequest',
            'HotelReadRequest',
            'PkgReadRequest',
            'ProfileReadRequest',
            'RailReadRequest',
            'VehicleReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AirReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: AirReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to AirReadRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\AirReadRequest $item
     * @return \StructType\ReadRequests
     */
    public function addToAirReadRequest(\StructType\AirReadRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirReadRequest) {
            throw new \InvalidArgumentException(sprintf('The AirReadRequest property can only contain items of type \StructType\AirReadRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToAirReadRequest($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->AirReadRequest[] = $item;
        return $this;
    }
    /**
     * Get CruiseReadRequest value
     * @return \StructType\CruiseReadRequest[]|null
     */
    public function getCruiseReadRequest()
    {
        return isset($this->CruiseReadRequest) ? $this->CruiseReadRequest : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCruiseReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCruiseReadRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCruiseReadRequestForArrayConstraintsFromSetCruiseReadRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readRequestsCruiseReadRequestItem) {
            // validation for constraint: itemType
            if (!$readRequestsCruiseReadRequestItem instanceof \StructType\CruiseReadRequest) {
                $invalidValues[] = is_object($readRequestsCruiseReadRequestItem) ? get_class($readRequestsCruiseReadRequestItem) : sprintf('%s(%s)', gettype($readRequestsCruiseReadRequestItem), var_export($readRequestsCruiseReadRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CruiseReadRequest property can only contain items of type \StructType\CruiseReadRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setCruiseReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCruiseReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCruiseReadRequestForChoiceConstraintsFromSetCruiseReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'GlobalReservationReadRequest',
            'AirReadRequest',
            'GolfReadRequest',
            'HotelReadRequest',
            'PkgReadRequest',
            'ProfileReadRequest',
            'RailReadRequest',
            'VehicleReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CruiseReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: CruiseReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set CruiseReadRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\CruiseReadRequest[] $cruiseReadRequest
     * @return \StructType\ReadRequests
     */
    public function setCruiseReadRequest(array $cruiseReadRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($cruiseReadRequestArrayErrorMessage = self::validateCruiseReadRequestForArrayConstraintsFromSetCruiseReadRequest($cruiseReadRequest))) {
            throw new \InvalidArgumentException($cruiseReadRequestArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($cruiseReadRequestChoiceErrorMessage = self::validateCruiseReadRequestForChoiceConstraintsFromSetCruiseReadRequest($cruiseReadRequest))) {
            throw new \InvalidArgumentException($cruiseReadRequestChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($cruiseReadRequest) && count($cruiseReadRequest) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($cruiseReadRequest)), __LINE__);
        }
        if (is_null($cruiseReadRequest) || (is_array($cruiseReadRequest) && empty($cruiseReadRequest))) {
            unset($this->CruiseReadRequest);
        } else {
            $this->CruiseReadRequest = $cruiseReadRequest;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToCruiseReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToCruiseReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToCruiseReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'GlobalReservationReadRequest',
            'AirReadRequest',
            'GolfReadRequest',
            'HotelReadRequest',
            'PkgReadRequest',
            'ProfileReadRequest',
            'RailReadRequest',
            'VehicleReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property CruiseReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: CruiseReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to CruiseReadRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\CruiseReadRequest $item
     * @return \StructType\ReadRequests
     */
    public function addToCruiseReadRequest(\StructType\CruiseReadRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CruiseReadRequest) {
            throw new \InvalidArgumentException(sprintf('The CruiseReadRequest property can only contain items of type \StructType\CruiseReadRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToCruiseReadRequest($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->CruiseReadRequest) && count($this->CruiseReadRequest) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->CruiseReadRequest)), __LINE__);
        }
        $this->CruiseReadRequest[] = $item;
        return $this;
    }
    /**
     * Get GolfReadRequest value
     * @return \StructType\GolfReadRequest[]|null
     */
    public function getGolfReadRequest()
    {
        return isset($this->GolfReadRequest) ? $this->GolfReadRequest : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGolfReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGolfReadRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGolfReadRequestForArrayConstraintsFromSetGolfReadRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readRequestsGolfReadRequestItem) {
            // validation for constraint: itemType
            if (!$readRequestsGolfReadRequestItem instanceof \StructType\GolfReadRequest) {
                $invalidValues[] = is_object($readRequestsGolfReadRequestItem) ? get_class($readRequestsGolfReadRequestItem) : sprintf('%s(%s)', gettype($readRequestsGolfReadRequestItem), var_export($readRequestsGolfReadRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GolfReadRequest property can only contain items of type \StructType\GolfReadRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setGolfReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGolfReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGolfReadRequestForChoiceConstraintsFromSetGolfReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'GlobalReservationReadRequest',
            'AirReadRequest',
            'CruiseReadRequest',
            'HotelReadRequest',
            'PkgReadRequest',
            'ProfileReadRequest',
            'RailReadRequest',
            'VehicleReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GolfReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: GolfReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set GolfReadRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\GolfReadRequest[] $golfReadRequest
     * @return \StructType\ReadRequests
     */
    public function setGolfReadRequest(array $golfReadRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($golfReadRequestArrayErrorMessage = self::validateGolfReadRequestForArrayConstraintsFromSetGolfReadRequest($golfReadRequest))) {
            throw new \InvalidArgumentException($golfReadRequestArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($golfReadRequestChoiceErrorMessage = self::validateGolfReadRequestForChoiceConstraintsFromSetGolfReadRequest($golfReadRequest))) {
            throw new \InvalidArgumentException($golfReadRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($golfReadRequest) || (is_array($golfReadRequest) && empty($golfReadRequest))) {
            unset($this->GolfReadRequest);
        } else {
            $this->GolfReadRequest = $golfReadRequest;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToGolfReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToGolfReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToGolfReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'GlobalReservationReadRequest',
            'AirReadRequest',
            'CruiseReadRequest',
            'HotelReadRequest',
            'PkgReadRequest',
            'ProfileReadRequest',
            'RailReadRequest',
            'VehicleReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GolfReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: GolfReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to GolfReadRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\GolfReadRequest $item
     * @return \StructType\ReadRequests
     */
    public function addToGolfReadRequest(\StructType\GolfReadRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GolfReadRequest) {
            throw new \InvalidArgumentException(sprintf('The GolfReadRequest property can only contain items of type \StructType\GolfReadRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToGolfReadRequest($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->GolfReadRequest[] = $item;
        return $this;
    }
    /**
     * Get HotelReadRequest value
     * @return \StructType\HotelReadRequest[]|null
     */
    public function getHotelReadRequest()
    {
        return isset($this->HotelReadRequest) ? $this->HotelReadRequest : null;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelReadRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelReadRequestForArrayConstraintsFromSetHotelReadRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readRequestsHotelReadRequestItem) {
            // validation for constraint: itemType
            if (!$readRequestsHotelReadRequestItem instanceof \StructType\HotelReadRequest) {
                $invalidValues[] = is_object($readRequestsHotelReadRequestItem) ? get_class($readRequestsHotelReadRequestItem) : sprintf('%s(%s)', gettype($readRequestsHotelReadRequestItem), var_export($readRequestsHotelReadRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelReadRequest property can only contain items of type \StructType\HotelReadRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setHotelReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHotelReadRequestForChoiceConstraintsFromSetHotelReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'GlobalReservationReadRequest',
            'AirReadRequest',
            'CruiseReadRequest',
            'GolfReadRequest',
            'PkgReadRequest',
            'ProfileReadRequest',
            'RailReadRequest',
            'VehicleReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property HotelReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: HotelReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set HotelReadRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\HotelReadRequest[] $hotelReadRequest
     * @return \StructType\ReadRequests
     */
    public function setHotelReadRequest(array $hotelReadRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelReadRequestArrayErrorMessage = self::validateHotelReadRequestForArrayConstraintsFromSetHotelReadRequest($hotelReadRequest))) {
            throw new \InvalidArgumentException($hotelReadRequestArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($hotelReadRequestChoiceErrorMessage = self::validateHotelReadRequestForChoiceConstraintsFromSetHotelReadRequest($hotelReadRequest))) {
            throw new \InvalidArgumentException($hotelReadRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($hotelReadRequest) || (is_array($hotelReadRequest) && empty($hotelReadRequest))) {
            unset($this->HotelReadRequest);
        } else {
            $this->HotelReadRequest = $hotelReadRequest;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToHotelReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToHotelReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToHotelReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'GlobalReservationReadRequest',
            'AirReadRequest',
            'CruiseReadRequest',
            'GolfReadRequest',
            'PkgReadRequest',
            'ProfileReadRequest',
            'RailReadRequest',
            'VehicleReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property HotelReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: HotelReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to HotelReadRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelReadRequest $item
     * @return \StructType\ReadRequests
     */
    public function addToHotelReadRequest(\StructType\HotelReadRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelReadRequest) {
            throw new \InvalidArgumentException(sprintf('The HotelReadRequest property can only contain items of type \StructType\HotelReadRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToHotelReadRequest($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->HotelReadRequest[] = $item;
        return $this;
    }
    /**
     * Get PkgReadRequest value
     * @return \StructType\PkgReadRequest[]|null
     */
    public function getPkgReadRequest()
    {
        return isset($this->PkgReadRequest) ? $this->PkgReadRequest : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPkgReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPkgReadRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePkgReadRequestForArrayConstraintsFromSetPkgReadRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readRequestsPkgReadRequestItem) {
            // validation for constraint: itemType
            if (!$readRequestsPkgReadRequestItem instanceof \StructType\PkgReadRequest) {
                $invalidValues[] = is_object($readRequestsPkgReadRequestItem) ? get_class($readRequestsPkgReadRequestItem) : sprintf('%s(%s)', gettype($readRequestsPkgReadRequestItem), var_export($readRequestsPkgReadRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PkgReadRequest property can only contain items of type \StructType\PkgReadRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setPkgReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPkgReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePkgReadRequestForChoiceConstraintsFromSetPkgReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'GlobalReservationReadRequest',
            'AirReadRequest',
            'CruiseReadRequest',
            'GolfReadRequest',
            'HotelReadRequest',
            'ProfileReadRequest',
            'RailReadRequest',
            'VehicleReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PkgReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: PkgReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set PkgReadRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\PkgReadRequest[] $pkgReadRequest
     * @return \StructType\ReadRequests
     */
    public function setPkgReadRequest(array $pkgReadRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($pkgReadRequestArrayErrorMessage = self::validatePkgReadRequestForArrayConstraintsFromSetPkgReadRequest($pkgReadRequest))) {
            throw new \InvalidArgumentException($pkgReadRequestArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($pkgReadRequestChoiceErrorMessage = self::validatePkgReadRequestForChoiceConstraintsFromSetPkgReadRequest($pkgReadRequest))) {
            throw new \InvalidArgumentException($pkgReadRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($pkgReadRequest) || (is_array($pkgReadRequest) && empty($pkgReadRequest))) {
            unset($this->PkgReadRequest);
        } else {
            $this->PkgReadRequest = $pkgReadRequest;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToPkgReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToPkgReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToPkgReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'GlobalReservationReadRequest',
            'AirReadRequest',
            'CruiseReadRequest',
            'GolfReadRequest',
            'HotelReadRequest',
            'ProfileReadRequest',
            'RailReadRequest',
            'VehicleReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property PkgReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: PkgReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to PkgReadRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\PkgReadRequest $item
     * @return \StructType\ReadRequests
     */
    public function addToPkgReadRequest(\StructType\PkgReadRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PkgReadRequest) {
            throw new \InvalidArgumentException(sprintf('The PkgReadRequest property can only contain items of type \StructType\PkgReadRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToPkgReadRequest($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->PkgReadRequest[] = $item;
        return $this;
    }
    /**
     * Get ProfileReadRequest value
     * @return \StructType\ProfileReadRequest[]|null
     */
    public function getProfileReadRequest()
    {
        return isset($this->ProfileReadRequest) ? $this->ProfileReadRequest : null;
    }
    /**
     * This method is responsible for validating the values passed to the setProfileReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfileReadRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProfileReadRequestForArrayConstraintsFromSetProfileReadRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readRequestsProfileReadRequestItem) {
            // validation for constraint: itemType
            if (!$readRequestsProfileReadRequestItem instanceof \StructType\ProfileReadRequest) {
                $invalidValues[] = is_object($readRequestsProfileReadRequestItem) ? get_class($readRequestsProfileReadRequestItem) : sprintf('%s(%s)', gettype($readRequestsProfileReadRequestItem), var_export($readRequestsProfileReadRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProfileReadRequest property can only contain items of type \StructType\ProfileReadRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setProfileReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfileReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateProfileReadRequestForChoiceConstraintsFromSetProfileReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'GlobalReservationReadRequest',
            'AirReadRequest',
            'CruiseReadRequest',
            'GolfReadRequest',
            'HotelReadRequest',
            'PkgReadRequest',
            'RailReadRequest',
            'VehicleReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ProfileReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: ProfileReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ProfileReadRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\ProfileReadRequest[] $profileReadRequest
     * @return \StructType\ReadRequests
     */
    public function setProfileReadRequest(array $profileReadRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($profileReadRequestArrayErrorMessage = self::validateProfileReadRequestForArrayConstraintsFromSetProfileReadRequest($profileReadRequest))) {
            throw new \InvalidArgumentException($profileReadRequestArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($profileReadRequestChoiceErrorMessage = self::validateProfileReadRequestForChoiceConstraintsFromSetProfileReadRequest($profileReadRequest))) {
            throw new \InvalidArgumentException($profileReadRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($profileReadRequest) || (is_array($profileReadRequest) && empty($profileReadRequest))) {
            unset($this->ProfileReadRequest);
        } else {
            $this->ProfileReadRequest = $profileReadRequest;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToProfileReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToProfileReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToProfileReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'GlobalReservationReadRequest',
            'AirReadRequest',
            'CruiseReadRequest',
            'GolfReadRequest',
            'HotelReadRequest',
            'PkgReadRequest',
            'RailReadRequest',
            'VehicleReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ProfileReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: ProfileReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to ProfileReadRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\ProfileReadRequest $item
     * @return \StructType\ReadRequests
     */
    public function addToProfileReadRequest(\StructType\ProfileReadRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProfileReadRequest) {
            throw new \InvalidArgumentException(sprintf('The ProfileReadRequest property can only contain items of type \StructType\ProfileReadRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToProfileReadRequest($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->ProfileReadRequest[] = $item;
        return $this;
    }
    /**
     * Get RailReadRequest value
     * @return \StructType\RailReadRequest[]|null
     */
    public function getRailReadRequest()
    {
        return isset($this->RailReadRequest) ? $this->RailReadRequest : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRailReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRailReadRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRailReadRequestForArrayConstraintsFromSetRailReadRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readRequestsRailReadRequestItem) {
            // validation for constraint: itemType
            if (!$readRequestsRailReadRequestItem instanceof \StructType\RailReadRequest) {
                $invalidValues[] = is_object($readRequestsRailReadRequestItem) ? get_class($readRequestsRailReadRequestItem) : sprintf('%s(%s)', gettype($readRequestsRailReadRequestItem), var_export($readRequestsRailReadRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RailReadRequest property can only contain items of type \StructType\RailReadRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setRailReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRailReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRailReadRequestForChoiceConstraintsFromSetRailReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'GlobalReservationReadRequest',
            'AirReadRequest',
            'CruiseReadRequest',
            'GolfReadRequest',
            'HotelReadRequest',
            'PkgReadRequest',
            'ProfileReadRequest',
            'VehicleReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RailReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: RailReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RailReadRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\RailReadRequest[] $railReadRequest
     * @return \StructType\ReadRequests
     */
    public function setRailReadRequest(array $railReadRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($railReadRequestArrayErrorMessage = self::validateRailReadRequestForArrayConstraintsFromSetRailReadRequest($railReadRequest))) {
            throw new \InvalidArgumentException($railReadRequestArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($railReadRequestChoiceErrorMessage = self::validateRailReadRequestForChoiceConstraintsFromSetRailReadRequest($railReadRequest))) {
            throw new \InvalidArgumentException($railReadRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($railReadRequest) || (is_array($railReadRequest) && empty($railReadRequest))) {
            unset($this->RailReadRequest);
        } else {
            $this->RailReadRequest = $railReadRequest;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToRailReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToRailReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToRailReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'GlobalReservationReadRequest',
            'AirReadRequest',
            'CruiseReadRequest',
            'GolfReadRequest',
            'HotelReadRequest',
            'PkgReadRequest',
            'ProfileReadRequest',
            'VehicleReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RailReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: RailReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to RailReadRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\RailReadRequest $item
     * @return \StructType\ReadRequests
     */
    public function addToRailReadRequest(\StructType\RailReadRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RailReadRequest) {
            throw new \InvalidArgumentException(sprintf('The RailReadRequest property can only contain items of type \StructType\RailReadRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToRailReadRequest($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->RailReadRequest[] = $item;
        return $this;
    }
    /**
     * Get VehicleReadRequest value
     * @return \StructType\VehicleReadRequest[]|null
     */
    public function getVehicleReadRequest()
    {
        return isset($this->VehicleReadRequest) ? $this->VehicleReadRequest : null;
    }
    /**
     * This method is responsible for validating the values passed to the setVehicleReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehicleReadRequest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVehicleReadRequestForArrayConstraintsFromSetVehicleReadRequest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readRequestsVehicleReadRequestItem) {
            // validation for constraint: itemType
            if (!$readRequestsVehicleReadRequestItem instanceof \StructType\VehicleReadRequest) {
                $invalidValues[] = is_object($readRequestsVehicleReadRequestItem) ? get_class($readRequestsVehicleReadRequestItem) : sprintf('%s(%s)', gettype($readRequestsVehicleReadRequestItem), var_export($readRequestsVehicleReadRequestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VehicleReadRequest property can only contain items of type \StructType\VehicleReadRequest, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setVehicleReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehicleReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVehicleReadRequestForChoiceConstraintsFromSetVehicleReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'GlobalReservationReadRequest',
            'AirReadRequest',
            'CruiseReadRequest',
            'GolfReadRequest',
            'HotelReadRequest',
            'PkgReadRequest',
            'ProfileReadRequest',
            'RailReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VehicleReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: VehicleReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set VehicleReadRequest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleReadRequest[] $vehicleReadRequest
     * @return \StructType\ReadRequests
     */
    public function setVehicleReadRequest(array $vehicleReadRequest = array())
    {
        // validation for constraint: array
        if ('' !== ($vehicleReadRequestArrayErrorMessage = self::validateVehicleReadRequestForArrayConstraintsFromSetVehicleReadRequest($vehicleReadRequest))) {
            throw new \InvalidArgumentException($vehicleReadRequestArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($vehicleReadRequestChoiceErrorMessage = self::validateVehicleReadRequestForChoiceConstraintsFromSetVehicleReadRequest($vehicleReadRequest))) {
            throw new \InvalidArgumentException($vehicleReadRequestChoiceErrorMessage, __LINE__);
        }
        if (is_null($vehicleReadRequest) || (is_array($vehicleReadRequest) && empty($vehicleReadRequest))) {
            unset($this->VehicleReadRequest);
        } else {
            $this->VehicleReadRequest = $vehicleReadRequest;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToVehicleReadRequest method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToVehicleReadRequest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToVehicleReadRequest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'ReadRequest',
            'GlobalReservationReadRequest',
            'AirReadRequest',
            'CruiseReadRequest',
            'GolfReadRequest',
            'HotelReadRequest',
            'PkgReadRequest',
            'ProfileReadRequest',
            'RailReadRequest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VehicleReadRequest can\'t be set as the property %s is already set. Only one property must be set among these properties: VehicleReadRequest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to VehicleReadRequest value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleReadRequest $item
     * @return \StructType\ReadRequests
     */
    public function addToVehicleReadRequest(\StructType\VehicleReadRequest $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleReadRequest) {
            throw new \InvalidArgumentException(sprintf('The VehicleReadRequest property can only contain items of type \StructType\VehicleReadRequest, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(ReadRequest, GlobalReservationReadRequest, AirReadRequest, CruiseReadRequest, GolfReadRequest, HotelReadRequest, PkgReadRequest, ProfileReadRequest, RailReadRequest, VehicleReadRequest)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToVehicleReadRequest($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->VehicleReadRequest[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReadRequests
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
