<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateRange StructType
 * Meta information extracted from the WSDL
 * - documentation: Minimum and maximum rate range. | Used to designate a date range for which the rates apply. | Provides rate range information. | Used to provide the minimum and maximum range of rates at this hotel property. | Requested rate or rate
 * range. Repeats to allow the identification of multiple ranges for multiple room stay candidates.
 * @subpackage Structs
 */
class RateRange extends AbstractStructBase
{
    /**
     * The RoomStayCandidateRPH
     * Meta information extracted from the WSDL
     * - documentation: Used to associate a rate range with a room stay candidate.
     * - use: optional
     * @var string
     */
    public $RoomStayCandidateRPH;
    /**
     * The RateMode
     * Meta information extracted from the WSDL
     * - documentation: This supports returning a type of rate (minimum, maximum, etc.) as an alternative to returning a specific rate. Refer to OpenTravel Code List Rate Mode (RMO).
     * - use: optional
     * @var string
     */
    public $RateMode;
    /**
     * The MaxResponses
     * Meta information extracted from the WSDL
     * - documentation: A positive integer value that indicates the maximum number of responses desired in the return.
     * - use: optional
     * @var int
     */
    public $MaxResponses;
    /**
     * The InfoSource
     * Meta information extracted from the WSDL
     * - documentation: Used to provide the source of the rate range.
     * - use: optional
     * @var string
     */
    public $InfoSource;
    /**
     * The TaxRate
     * Meta information extracted from the WSDL
     * - documentation: The tax rate at this property.
     * - use: optional
     * @var float
     */
    public $TaxRate;
    /**
     * The RateInfoNotAvailableInd
     * Meta information extracted from the WSDL
     * - documentation: When true, rate information is not available.
     * - use: optional
     * @var bool
     */
    public $RateInfoNotAvailableInd;
    /**
     * Constructor method for RateRange
     * @uses RateRange::setRoomStayCandidateRPH()
     * @uses RateRange::setRateMode()
     * @uses RateRange::setMaxResponses()
     * @uses RateRange::setInfoSource()
     * @uses RateRange::setTaxRate()
     * @uses RateRange::setRateInfoNotAvailableInd()
     * @param string $roomStayCandidateRPH
     * @param string $rateMode
     * @param int $maxResponses
     * @param string $infoSource
     * @param float $taxRate
     * @param bool $rateInfoNotAvailableInd
     */
    public function __construct($roomStayCandidateRPH = null, $rateMode = null, $maxResponses = null, $infoSource = null, $taxRate = null, $rateInfoNotAvailableInd = null)
    {
        $this
            ->setRoomStayCandidateRPH($roomStayCandidateRPH)
            ->setRateMode($rateMode)
            ->setMaxResponses($maxResponses)
            ->setInfoSource($infoSource)
            ->setTaxRate($taxRate)
            ->setRateInfoNotAvailableInd($rateInfoNotAvailableInd);
    }
    /**
     * Get RoomStayCandidateRPH value
     * @return string|null
     */
    public function getRoomStayCandidateRPH()
    {
        return $this->RoomStayCandidateRPH;
    }
    /**
     * Set RoomStayCandidateRPH value
     * @param string $roomStayCandidateRPH
     * @return \StructType\RateRange
     */
    public function setRoomStayCandidateRPH($roomStayCandidateRPH = null)
    {
        // validation for constraint: string
        if (!is_null($roomStayCandidateRPH) && !is_string($roomStayCandidateRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomStayCandidateRPH, true), gettype($roomStayCandidateRPH)), __LINE__);
        }
        $this->RoomStayCandidateRPH = $roomStayCandidateRPH;
        return $this;
    }
    /**
     * Get RateMode value
     * @return string|null
     */
    public function getRateMode()
    {
        return $this->RateMode;
    }
    /**
     * Set RateMode value
     * @param string $rateMode
     * @return \StructType\RateRange
     */
    public function setRateMode($rateMode = null)
    {
        // validation for constraint: string
        if (!is_null($rateMode) && !is_string($rateMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateMode, true), gettype($rateMode)), __LINE__);
        }
        $this->RateMode = $rateMode;
        return $this;
    }
    /**
     * Get MaxResponses value
     * @return int|null
     */
    public function getMaxResponses()
    {
        return $this->MaxResponses;
    }
    /**
     * Set MaxResponses value
     * @param int $maxResponses
     * @return \StructType\RateRange
     */
    public function setMaxResponses($maxResponses = null)
    {
        // validation for constraint: int
        if (!is_null($maxResponses) && !(is_int($maxResponses) || ctype_digit($maxResponses))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxResponses, true), gettype($maxResponses)), __LINE__);
        }
        $this->MaxResponses = $maxResponses;
        return $this;
    }
    /**
     * Get InfoSource value
     * @return string|null
     */
    public function getInfoSource()
    {
        return $this->InfoSource;
    }
    /**
     * Set InfoSource value
     * @param string $infoSource
     * @return \StructType\RateRange
     */
    public function setInfoSource($infoSource = null)
    {
        // validation for constraint: string
        if (!is_null($infoSource) && !is_string($infoSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoSource, true), gettype($infoSource)), __LINE__);
        }
        $this->InfoSource = $infoSource;
        return $this;
    }
    /**
     * Get TaxRate value
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->TaxRate;
    }
    /**
     * Set TaxRate value
     * @param float $taxRate
     * @return \StructType\RateRange
     */
    public function setTaxRate($taxRate = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate) && !(is_float($taxRate) || is_numeric($taxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate, true), gettype($taxRate)), __LINE__);
        }
        $this->TaxRate = $taxRate;
        return $this;
    }
    /**
     * Get RateInfoNotAvailableInd value
     * @return bool|null
     */
    public function getRateInfoNotAvailableInd()
    {
        return $this->RateInfoNotAvailableInd;
    }
    /**
     * Set RateInfoNotAvailableInd value
     * @param bool $rateInfoNotAvailableInd
     * @return \StructType\RateRange
     */
    public function setRateInfoNotAvailableInd($rateInfoNotAvailableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($rateInfoNotAvailableInd) && !is_bool($rateInfoNotAvailableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rateInfoNotAvailableInd, true), gettype($rateInfoNotAvailableInd)), __LINE__);
        }
        $this->RateInfoNotAvailableInd = $rateInfoNotAvailableInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateRange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
