<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePolicy StructType
 * Meta information extracted from the WSDL
 * - documentation: A rate policy description.
 * @subpackage Structs
 */
class RatePolicy extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Type
     */
    public $Type;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Details about a rate policy.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Description;
    /**
     * The SubjectToChangeInd
     * Meta information extracted from the WSDL
     * - documentation: When true, government rates subject to change without notice.
     * - use: optional
     * @var bool
     */
    public $SubjectToChangeInd;
    /**
     * The ID_RequiredInd
     * Meta information extracted from the WSDL
     * - documentation: When true, ID is required at check-in.
     * - use: optional
     * @var bool
     */
    public $ID_RequiredInd;
    /**
     * The GuestType
     * Meta information extracted from the WSDL
     * - documentation: The guest type(s) for the policy. Use a value from the OpenTravel Hotel Guest Type (GUE) code list.
     * - use: optional
     * @var list
     */
    public $GuestType;
    /**
     * The MinRoomNightCommitment
     * Meta information extracted from the WSDL
     * - documentation: Identifies the minimum number of nights a guest has to stay in a room in order to be eligible for the rate.
     * - use: optional
     * @var int
     */
    public $MinRoomNightCommitment;
    /**
     * The RateOfferType
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate the alternate rate plan type to be offered. Refer to OpenTravel Code List Rate Plan Type (RPT).
     * - use: optional
     * @var string
     */
    public $RateOfferType;
    /**
     * The CorporateID_Ind
     * Meta information extracted from the WSDL
     * - documentation: When true, a corporate ID is required to book a corporate rate.
     * - use: optional
     * @var bool
     */
    public $CorporateID_Ind;
    /**
     * Constructor method for RatePolicy
     * @uses RatePolicy::setType()
     * @uses RatePolicy::setDescription()
     * @uses RatePolicy::setSubjectToChangeInd()
     * @uses RatePolicy::setID_RequiredInd()
     * @uses RatePolicy::setGuestType()
     * @uses RatePolicy::setMinRoomNightCommitment()
     * @uses RatePolicy::setRateOfferType()
     * @uses RatePolicy::setCorporateID_Ind()
     * @param \StructType\Type $type
     * @param mixed[] $description
     * @param bool $subjectToChangeInd
     * @param bool $iD_RequiredInd
     * @param list $guestType
     * @param int $minRoomNightCommitment
     * @param string $rateOfferType
     * @param bool $corporateID_Ind
     */
    public function __construct(\StructType\Type $type = null, array $description = array(), $subjectToChangeInd = null, $iD_RequiredInd = null, list $guestType = null, $minRoomNightCommitment = null, $rateOfferType = null, $corporateID_Ind = null)
    {
        $this
            ->setType($type)
            ->setDescription($description)
            ->setSubjectToChangeInd($subjectToChangeInd)
            ->setID_RequiredInd($iD_RequiredInd)
            ->setGuestType($guestType)
            ->setMinRoomNightCommitment($minRoomNightCommitment)
            ->setRateOfferType($rateOfferType)
            ->setCorporateID_Ind($corporateID_Ind);
    }
    /**
     * Get Type value
     * @return \StructType\Type|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param \StructType\Type $type
     * @return \StructType\RatePolicy
     */
    public function setType(\StructType\Type $type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Description value
     * @return mixed[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ratePolicyDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($ratePolicyDescriptionItem) ? get_class($ratePolicyDescriptionItem) : sprintf('%s(%s)', gettype($ratePolicyDescriptionItem), var_export($ratePolicyDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param mixed[] $description
     * @return \StructType\RatePolicy
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\RatePolicy
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get SubjectToChangeInd value
     * @return bool|null
     */
    public function getSubjectToChangeInd()
    {
        return $this->SubjectToChangeInd;
    }
    /**
     * Set SubjectToChangeInd value
     * @param bool $subjectToChangeInd
     * @return \StructType\RatePolicy
     */
    public function setSubjectToChangeInd($subjectToChangeInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($subjectToChangeInd) && !is_bool($subjectToChangeInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($subjectToChangeInd, true), gettype($subjectToChangeInd)), __LINE__);
        }
        $this->SubjectToChangeInd = $subjectToChangeInd;
        return $this;
    }
    /**
     * Get ID_RequiredInd value
     * @return bool|null
     */
    public function getID_RequiredInd()
    {
        return $this->ID_RequiredInd;
    }
    /**
     * Set ID_RequiredInd value
     * @param bool $iD_RequiredInd
     * @return \StructType\RatePolicy
     */
    public function setID_RequiredInd($iD_RequiredInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($iD_RequiredInd) && !is_bool($iD_RequiredInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($iD_RequiredInd, true), gettype($iD_RequiredInd)), __LINE__);
        }
        $this->ID_RequiredInd = $iD_RequiredInd;
        return $this;
    }
    /**
     * Get GuestType value
     * @return list|null
     */
    public function getGuestType()
    {
        return $this->GuestType;
    }
    /**
     * Set GuestType value
     * @param list $guestType
     * @return \StructType\RatePolicy
     */
    public function setGuestType(list $guestType = null)
    {
        $this->GuestType = $guestType;
        return $this;
    }
    /**
     * Get MinRoomNightCommitment value
     * @return int|null
     */
    public function getMinRoomNightCommitment()
    {
        return $this->MinRoomNightCommitment;
    }
    /**
     * Set MinRoomNightCommitment value
     * @param int $minRoomNightCommitment
     * @return \StructType\RatePolicy
     */
    public function setMinRoomNightCommitment($minRoomNightCommitment = null)
    {
        // validation for constraint: int
        if (!is_null($minRoomNightCommitment) && !(is_int($minRoomNightCommitment) || ctype_digit($minRoomNightCommitment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minRoomNightCommitment, true), gettype($minRoomNightCommitment)), __LINE__);
        }
        $this->MinRoomNightCommitment = $minRoomNightCommitment;
        return $this;
    }
    /**
     * Get RateOfferType value
     * @return string|null
     */
    public function getRateOfferType()
    {
        return $this->RateOfferType;
    }
    /**
     * Set RateOfferType value
     * @param string $rateOfferType
     * @return \StructType\RatePolicy
     */
    public function setRateOfferType($rateOfferType = null)
    {
        // validation for constraint: string
        if (!is_null($rateOfferType) && !is_string($rateOfferType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rateOfferType, true), gettype($rateOfferType)), __LINE__);
        }
        $this->RateOfferType = $rateOfferType;
        return $this;
    }
    /**
     * Get CorporateID_Ind value
     * @return bool|null
     */
    public function getCorporateID_Ind()
    {
        return $this->CorporateID_Ind;
    }
    /**
     * Set CorporateID_Ind value
     * @param bool $corporateID_Ind
     * @return \StructType\RatePolicy
     */
    public function setCorporateID_Ind($corporateID_Ind = null)
    {
        // validation for constraint: boolean
        if (!is_null($corporateID_Ind) && !is_bool($corporateID_Ind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($corporateID_Ind, true), gettype($corporateID_Ind)), __LINE__);
        }
        $this->CorporateID_Ind = $corporateID_Ind;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RatePolicy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
